/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils;

import java.io.IOException;
import java.util.List;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.CompatibilityUtil;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeDeserializerAdapter;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.UnloadableDummyTypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.types.DataTypes;
import org.apache.flink.table.types.TypeConverters;
import org.apache.flink.util.Preconditions;

public abstract class AbstractRowSerializer<T extends BaseRow>
extends TypeSerializer<T> {
    private static final long serialVersionUID = -3420438571863908761L;
    protected final int numFields;
    protected final TypeInformation<?>[] types;
    protected final TypeSerializer[] serializers;

    public AbstractRowSerializer(TypeInformation<?>[] types) {
        this.types = Preconditions.checkNotNull(types);
        this.numFields = types.length;
        TypeSerializer[] fieldSerializers = new TypeSerializer[types.length];
        for (int i = 0; i < types.length; ++i) {
            fieldSerializers[i] = DataTypes.createInternalSerializer(TypeConverters.createInternalTypeFromTypeInfo(types[i]));
        }
        this.serializers = fieldSerializers;
    }

    public int getNumFields() {
        return this.numFields;
    }

    public TypeInformation<?>[] getTypes() {
        return this.types;
    }

    public abstract BinaryRow baseRowToBinary(T var1) throws IOException;

    @Override
    public TypeSerializerConfigSnapshot snapshotConfiguration() {
        return new RowSerializerConfigSnapshot(this.serializers);
    }

    @Override
    public CompatibilityResult<T> ensureCompatibility(TypeSerializerConfigSnapshot configSnapshot) {
        if (configSnapshot instanceof RowSerializerConfigSnapshot) {
            TypeSerializer[] fieldSerializers = this.serializers;
            List<Tuple2<TypeSerializer<?>, TypeSerializerConfigSnapshot>> previousFieldSerializersAndConfigs = ((RowSerializerConfigSnapshot)configSnapshot).getNestedSerializersAndConfigs();
            if (previousFieldSerializersAndConfigs.size() == fieldSerializers.length) {
                boolean requireMigration = false;
                TypeSerializer[] convertDeserializers = new TypeSerializer[fieldSerializers.length];
                int i = 0;
                for (Tuple2<TypeSerializer<?>, TypeSerializerConfigSnapshot> f : previousFieldSerializersAndConfigs) {
                    CompatibilityResult compatResult = CompatibilityUtil.resolveCompatibilityResult((TypeSerializer)f.f0, UnloadableDummyTypeSerializer.class, (TypeSerializerConfigSnapshot)f.f1, fieldSerializers[i]);
                    if (compatResult.isRequiresMigration()) {
                        requireMigration = true;
                        if (compatResult.getConvertDeserializer() == null) {
                            return CompatibilityResult.requiresMigration();
                        }
                        convertDeserializers[i] = new TypeDeserializerAdapter(compatResult.getConvertDeserializer());
                    }
                    ++i;
                }
                if (requireMigration) {
                    return CompatibilityResult.requiresMigration(this);
                }
                return CompatibilityResult.compatible();
            }
        }
        return CompatibilityResult.requiresMigration();
    }

    public static final class RowSerializerConfigSnapshot
    extends CompositeTypeSerializerConfigSnapshot {
        private static final int VERSION = 1;

        public RowSerializerConfigSnapshot() {
        }

        public RowSerializerConfigSnapshot(TypeSerializer[] fieldSerializers) {
            super(fieldSerializers);
        }

        @Override
        public int getVersion() {
            return 1;
        }
    }
}

