/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.dataformat.BaseMap;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.typeutils.BaseMapSerializer;

public class BaseMapTypeInfo
extends TypeInformation<BaseMap> {
    private static final long serialVersionUID = 1L;
    private final DataType keyType;
    private final DataType valueType;

    public BaseMapTypeInfo(DataType keyType, DataType valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public DataType getKeyType() {
        return this.keyType;
    }

    public DataType getValueType() {
        return this.valueType;
    }

    @Override
    public boolean isBasicType() {
        return false;
    }

    @Override
    public boolean isTupleType() {
        return false;
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public int getTotalFields() {
        return 1;
    }

    @Override
    public Class<BaseMap> getTypeClass() {
        return BaseMap.class;
    }

    @Override
    public boolean isKeyType() {
        return false;
    }

    @Override
    public TypeSerializer<BaseMap> createSerializer(ExecutionConfig executionConfig) {
        return new BaseMapSerializer(this.keyType.toInternalType(), this.valueType.toInternalType());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "<" + this.keyType.toInternalType() + ", " + this.valueType.toInternalType() + ">";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BaseMapTypeInfo) {
            BaseMapTypeInfo typeInfo = (BaseMapTypeInfo)obj;
            return typeInfo.canEqual(this) && this.keyType.toInternalType() == typeInfo.keyType.toInternalType() && this.valueType.toInternalType().equals(typeInfo.valueType.toInternalType());
        }
        return false;
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof BaseMapTypeInfo;
    }

    @Override
    public int hashCode() {
        return 31 * this.keyType.toInternalType().hashCode() + this.valueType.toInternalType().hashCode();
    }
}

