/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.dataformat.BinaryArray;

public class BinaryArraySerializer
extends TypeSerializerSingleton<BinaryArray> {
    public static final BinaryArraySerializer INSTANCE = new BinaryArraySerializer();

    private BinaryArraySerializer() {
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public BinaryArray createInstance() {
        return new BinaryArray();
    }

    @Override
    public BinaryArray copy(BinaryArray from) {
        return from.copy();
    }

    @Override
    public BinaryArray copy(BinaryArray from, BinaryArray reuse) {
        return from.copy(reuse);
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(BinaryArray record, DataOutputView target) throws IOException {
        byte[] bytes = record.getBytes();
        target.writeInt(bytes.length);
        target.write(bytes);
    }

    @Override
    public BinaryArray deserialize(DataInputView source) throws IOException {
        return this.deserialize(new BinaryArray(), source);
    }

    @Override
    public BinaryArray deserialize(BinaryArray reuse, DataInputView source) throws IOException {
        int length = source.readInt();
        byte[] bytes = new byte[length];
        source.readFully(bytes);
        reuse.pointTo(MemorySegmentFactory.wrap(bytes), 0, bytes.length);
        return reuse;
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int length = source.readInt();
        byte[] bytes = new byte[length];
        source.readFully(bytes);
        target.writeInt(length);
        target.write(bytes);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof BinaryArraySerializer;
    }
}

