/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils;

import java.io.Serializable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.Comparator;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.SortedMapSerializer;
import org.apache.flink.shaded.guava18.com.google.common.primitives.UnsignedBytes;
import org.apache.flink.table.api.dataview.SortedMapView;
import org.apache.flink.table.typeutils.NullSerializer;
import org.apache.flink.table.typeutils.SortedMapViewSerializer;

@PublicEvolving
public class SortedMapViewTypeInfo<K, V>
extends TypeInformation<SortedMapView<K, V>> {
    public final Comparator<K> comparator;
    public TypeInformation<K> keyType;
    public TypeInformation<V> valueType;
    public boolean nullSerializer = false;

    public SortedMapViewTypeInfo(Comparator<K> comparator, TypeInformation<K> keyType, TypeInformation<V> valueType) {
        this.comparator = comparator;
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    public boolean isBasicType() {
        return false;
    }

    @Override
    public boolean isTupleType() {
        return false;
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public int getTotalFields() {
        return 1;
    }

    @Override
    public Class<SortedMapView<K, V>> getTypeClass() {
        return SortedMapView.class;
    }

    @Override
    public boolean isKeyType() {
        return false;
    }

    @Override
    public TypeSerializer<SortedMapView<K, V>> createSerializer(ExecutionConfig config) {
        if (this.nullSerializer) {
            return new NullSerializer();
        }
        ComparableComparator keyComparaotr = this.comparator != null ? this.comparator : new ComparableComparator();
        TypeSerializer<K> keySer = this.keyType.createSerializer(config);
        TypeSerializer<V> valueSer = this.valueType.createSerializer(config);
        return new SortedMapViewSerializer(new SortedMapSerializer(keyComparaotr, keySer, valueSer));
    }

    @Override
    public String toString() {
        return "SortedMapView<" + this.keyType.toString() + ", " + this.valueType.toString() + ">";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SortedMapViewTypeInfo) {
            SortedMapViewTypeInfo other = (SortedMapViewTypeInfo)obj;
            return other.canEqual(this) && this.keyType.equals(other.keyType) && this.valueType.equals(other.valueType) && this.comparator.equals(other.comparator) && this.nullSerializer == other.nullSerializer;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 961 * this.keyType.hashCode() + 31 * this.valueType.hashCode() + Boolean.hashCode(this.nullSerializer);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }

    public SortedMapViewTypeInfo<K, V> copy(boolean nullSerializer) {
        SortedMapViewTypeInfo<K, V> ret = new SortedMapViewTypeInfo<K, V>(this.comparator, this.keyType, this.valueType);
        ret.nullSerializer = nullSerializer;
        return ret;
    }

    public static class ByteArrayComparator
    implements Comparator<byte[]>,
    Serializable {
        private static final long serialVersionUID = 1318143293435568038L;
        private transient java.util.Comparator<byte[]> comparator;
        private boolean asc;

        public ByteArrayComparator() {
            this(true);
        }

        public ByteArrayComparator(boolean asc) {
            this.asc = asc;
            this.initComparator();
        }

        private void initComparator() {
            this.comparator = UnsignedBytes.lexicographicalComparator();
            if (!this.asc) {
                this.comparator = this.comparator.reversed();
            }
        }

        @Override
        public int compare(byte[] o1, byte[] o2) {
            if (this.comparator == null) {
                this.initComparator();
            }
            return this.comparator.compare(o1, o2);
        }

        public int hashCode() {
            return "ByteArrayComparator".hashCode();
        }

        @Override
        public boolean equals(Object object) {
            return this == object || null != object && object.getClass().equals(this.getClass());
        }
    }

    public static class ComparableComparator<K>
    implements Comparator<K>,
    Serializable {
        private static final long serialVersionUID = 1318143293435568038L;
        private boolean asc;

        public ComparableComparator() {
            this.asc = true;
        }

        public ComparableComparator(boolean asc) {
            this.asc = asc;
        }

        @Override
        public int compare(K o1, K o2) {
            int cmp = ((Comparable)o1).compareTo(o2);
            return this.asc ? cmp : -cmp;
        }

        public int hashCode() {
            return "ComparableComparator".hashCode();
        }

        @Override
        public boolean equals(Object object) {
            return this == object || null != object && object.getClass().equals(this.getClass());
        }
    }
}

