/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.types.ArrayType;
import org.apache.flink.table.types.BooleanType;
import org.apache.flink.table.types.ByteArrayType;
import org.apache.flink.table.types.ByteType;
import org.apache.flink.table.types.DataTypes;
import org.apache.flink.table.types.DateType;
import org.apache.flink.table.types.DecimalType;
import org.apache.flink.table.types.DoubleType;
import org.apache.flink.table.types.FloatType;
import org.apache.flink.table.types.GenericType;
import org.apache.flink.table.types.IntType;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.LongType;
import org.apache.flink.table.types.MapType;
import org.apache.flink.table.types.RowType;
import org.apache.flink.table.types.ShortType;
import org.apache.flink.table.types.StringType;
import org.apache.flink.table.types.TimeType;
import org.apache.flink.table.types.TimestampType;
import org.apache.flink.table.types.TypeConverters$;
import org.apache.flink.table.typeutils.BaseRowTypeInfo;
import org.apache.flink.table.validate.ValidationFailure;
import org.apache.flink.table.validate.ValidationResult;
import org.apache.flink.table.validate.ValidationSuccess$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;

public final class TypeCheckUtils$ {
    public static final TypeCheckUtils$ MODULE$;

    static {
        new TypeCheckUtils$();
    }

    public boolean isNumeric(InternalType dataType2) {
        boolean bl;
        InternalType internalType = dataType2;
        IntType intType = DataTypes.INT;
        InternalType internalType2 = internalType;
        if (!(intType != null ? !((Object)intType).equals(internalType2) : internalType2 != null)) {
            bl = true;
        } else {
            ByteType byteType = DataTypes.BYTE;
            InternalType internalType3 = internalType;
            if (!(byteType != null ? !((Object)byteType).equals(internalType3) : internalType3 != null)) {
                bl = true;
            } else {
                ShortType shortType = DataTypes.SHORT;
                InternalType internalType4 = internalType;
                if (!(shortType != null ? !((Object)shortType).equals(internalType4) : internalType4 != null)) {
                    bl = true;
                } else {
                    LongType longType = DataTypes.LONG;
                    InternalType internalType5 = internalType;
                    if (!(longType != null ? !((Object)longType).equals(internalType5) : internalType5 != null)) {
                        bl = true;
                    } else {
                        FloatType floatType = DataTypes.FLOAT;
                        InternalType internalType6 = internalType;
                        if (!(floatType != null ? !((Object)floatType).equals(internalType6) : internalType6 != null)) {
                            bl = true;
                        } else {
                            DoubleType doubleType = DataTypes.DOUBLE;
                            InternalType internalType7 = internalType;
                            bl = !(doubleType != null ? !((Object)doubleType).equals(internalType7) : internalType7 != null);
                        }
                    }
                }
            }
        }
        boolean bl2 = bl ? true : internalType instanceof DecimalType;
        return bl2;
    }

    public boolean isTemporal(InternalType dataType2) {
        return this.isTimePoint(dataType2) || this.isTimeInterval(dataType2);
    }

    public boolean isTimePoint(InternalType dataType2) {
        boolean bl;
        boolean bl2;
        InternalType internalType = dataType2;
        TimestampType timestampType = DataTypes.INTERVAL_MILLIS;
        InternalType internalType2 = internalType;
        if (!(timestampType != null ? !((Object)timestampType).equals(internalType2) : internalType2 != null)) {
            bl2 = true;
        } else {
            DateType dateType = DataTypes.INTERVAL_MONTHS;
            InternalType internalType3 = internalType;
            bl2 = !(dateType != null ? !((Object)dateType).equals(internalType3) : internalType3 != null);
        }
        if (bl2) {
            bl = false;
        } else {
            boolean bl3 = internalType instanceof TimeType ? true : (internalType instanceof DateType ? true : internalType instanceof TimestampType);
            bl = bl3;
        }
        return bl;
    }

    public boolean isRowTime(InternalType dataType2) {
        InternalType internalType = dataType2;
        TimestampType timestampType = DataTypes.ROWTIME_INDICATOR;
        return !(internalType != null ? !internalType.equals(timestampType) : timestampType != null);
    }

    public boolean isProcTime(InternalType dataType2) {
        InternalType internalType = dataType2;
        TimestampType timestampType = DataTypes.PROCTIME_INDICATOR;
        return !(internalType != null ? !internalType.equals(timestampType) : timestampType != null);
    }

    public boolean isTimeInterval(InternalType dataType2) {
        boolean bl;
        InternalType internalType = dataType2;
        TimestampType timestampType = DataTypes.INTERVAL_MILLIS;
        InternalType internalType2 = internalType;
        if (!(timestampType != null ? !((Object)timestampType).equals(internalType2) : internalType2 != null)) {
            bl = true;
        } else {
            DateType dateType = DataTypes.INTERVAL_MONTHS;
            InternalType internalType3 = internalType;
            bl = !(dateType != null ? !((Object)dateType).equals(internalType3) : internalType3 != null);
        }
        boolean bl2 = bl;
        return bl2;
    }

    public boolean isString(InternalType dataType2) {
        InternalType internalType = dataType2;
        StringType stringType = DataTypes.STRING;
        return !(internalType != null ? !internalType.equals(stringType) : stringType != null);
    }

    public boolean isBinary(InternalType dataType2) {
        InternalType internalType = dataType2;
        ByteArrayType byteArrayType = DataTypes.BYTE_ARRAY;
        return !(internalType != null ? !internalType.equals(byteArrayType) : byteArrayType != null);
    }

    public boolean isBoolean(InternalType dataType2) {
        InternalType internalType = dataType2;
        BooleanType booleanType = DataTypes.BOOLEAN;
        return !(internalType != null ? !internalType.equals(booleanType) : booleanType != null);
    }

    public boolean isDecimal(InternalType dataType2) {
        return dataType2 instanceof DecimalType;
    }

    public boolean isInteger(InternalType dataType2) {
        InternalType internalType = dataType2;
        IntType intType = DataTypes.INT;
        return !(internalType != null ? !internalType.equals(intType) : intType != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isIntegerFamily(InternalType dataType2) {
        InternalType internalType = dataType2;
        IntType intType = DataTypes.INT;
        if (internalType == null) {
            if (intType == null) return true;
        } else if (internalType.equals(intType)) return true;
        InternalType internalType2 = dataType2;
        ByteType byteType = DataTypes.BYTE;
        if (internalType2 == null) {
            if (byteType == null) return true;
        } else if (internalType2.equals(byteType)) return true;
        InternalType internalType3 = dataType2;
        LongType longType = DataTypes.LONG;
        if (internalType3 == null) {
            if (longType == null) return true;
        } else if (internalType3.equals(longType)) return true;
        InternalType internalType4 = dataType2;
        ShortType shortType = DataTypes.SHORT;
        if (internalType4 != null) {
            if (!internalType4.equals(shortType)) return false;
            return true;
        }
        if (shortType == null) return true;
        return false;
    }

    public boolean isSimpleStringRepresentation(InternalType dataType2) {
        return this.isNumeric(dataType2) || this.isString(dataType2) || this.isTemporal(dataType2) || this.isBoolean(dataType2);
    }

    public boolean isLong(InternalType dataType2) {
        InternalType internalType = dataType2;
        LongType longType = DataTypes.LONG;
        return !(internalType != null ? !internalType.equals(longType) : longType != null);
    }

    public boolean isIntervalMonths(InternalType dataType2) {
        InternalType internalType = dataType2;
        DateType dateType = DataTypes.INTERVAL_MONTHS;
        return !(internalType != null ? !internalType.equals(dateType) : dateType != null);
    }

    public boolean isIntervalMillis(InternalType dataType2) {
        InternalType internalType = dataType2;
        TimestampType timestampType = DataTypes.INTERVAL_MILLIS;
        return !(internalType != null ? !internalType.equals(timestampType) : timestampType != null);
    }

    public boolean isArray(InternalType dataType2) {
        return dataType2 instanceof ArrayType;
    }

    public boolean isMap(InternalType dataType2) {
        return dataType2 instanceof MapType;
    }

    public boolean isList(InternalType dataType2) {
        boolean bl;
        InternalType internalType = dataType2;
        if (internalType instanceof GenericType) {
            GenericType genericType = (GenericType)internalType;
            bl = genericType.getTypeInfo() instanceof ListTypeInfo;
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isIntegral(InternalType dataType2) {
        boolean bl;
        InternalType internalType = dataType2;
        ByteType byteType = DataTypes.BYTE;
        InternalType internalType2 = internalType;
        if (!(byteType != null ? !((Object)byteType).equals(internalType2) : internalType2 != null)) {
            bl = true;
        } else {
            ShortType shortType = DataTypes.SHORT;
            InternalType internalType3 = internalType;
            if (!(shortType != null ? !((Object)shortType).equals(internalType3) : internalType3 != null)) {
                bl = true;
            } else {
                IntType intType = DataTypes.INT;
                InternalType internalType4 = internalType;
                if (!(intType != null ? !((Object)intType).equals(internalType4) : internalType4 != null)) {
                    bl = true;
                } else {
                    LongType longType = DataTypes.LONG;
                    InternalType internalType5 = internalType;
                    bl = !(longType != null ? !((Object)longType).equals(internalType5) : internalType5 != null);
                }
            }
        }
        boolean bl2 = bl;
        return bl2;
    }

    public boolean isComparable(InternalType dataType2) {
        return !(dataType2 instanceof GenericType) && !(dataType2 instanceof MapType) && !(dataType2 instanceof RowType) && !this.isArray(dataType2);
    }

    public ValidationResult assertNumericExpr(InternalType dataType2, String caller) {
        InternalType internalType = dataType2;
        ValidationResult validationResult = this.isNumeric(internalType) ? ValidationSuccess$.MODULE$ : new ValidationFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " requires numeric types, get ", " here"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{caller, dataType2})));
        return validationResult;
    }

    public ValidationResult assertIntegerFamilyExpr(InternalType dataType2, String caller) {
        InternalType internalType = dataType2;
        ValidationResult validationResult = this.isIntegral(internalType) ? ValidationSuccess$.MODULE$ : new ValidationFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " requires integer types but was '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{caller, dataType2})));
        return validationResult;
    }

    public ValidationResult assertOrderableExpr(InternalType dataType2, String caller) {
        return TypeConverters$.MODULE$.createExternalTypeInfoFromDataType(dataType2).isSortKeyType() ? ValidationSuccess$.MODULE$ : new ValidationFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " requires orderable types, get ", " here"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{caller, dataType2})));
    }

    public void validateEqualsHashCode(String name, TypeInformation<?> t) {
        TypeInformation<?> typeInformation;
        block6: {
            block3: {
                block5: {
                    block4: {
                        block2: {
                            typeInformation = t;
                            if (!(typeInformation instanceof PojoTypeInfo)) break block2;
                            PojoTypeInfo pojoTypeInfo = (PojoTypeInfo)typeInformation;
                            this.validateEqualsHashCode(name, pojoTypeInfo.getClass());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!(typeInformation instanceof BaseRowTypeInfo)) break block4;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!(typeInformation instanceof CompositeType)) break block5;
                    CompositeType compositeType = (CompositeType)typeInformation;
                    this.validateEqualsHashCode(name, t.getTypeClass());
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), compositeType.getArity()).foreach$mVc$sp((Function1)new Serializable(name, compositeType){
                        public static final long serialVersionUID = 0L;
                        private final String name$1;
                        private final CompositeType x4$1;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            TypeInformation<X> subtype = this.x4$1.getTypeAt(i);
                            TypeCheckUtils$.MODULE$.validateEqualsHashCode(this.name$1, subtype);
                        }
                        {
                            this.name$1 = name$1;
                            this.x4$1 = x4$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (typeInformation == null) break block6;
                this.validateEqualsHashCode(name, t.getTypeClass());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(typeInformation);
    }

    public void validateEqualsHashCode(String name, Class<?> c) {
        block4: {
            BoxedUnit boxedUnit;
            while (true) {
                if (c.isPrimitive()) {
                    boxedUnit = BoxedUnit.UNIT;
                    break block4;
                }
                if (!c.isArray()) break;
                c = c.getComponentType();
            }
            if (c.getMethod("hashCode", new Class[0]).getDeclaringClass() == Object.class) {
                throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Type '", "' cannot be used in a ", " operation because it "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c.getCanonicalName(), name}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"does not implement a proper hashCode() method."})).s((Seq)Nil$.MODULE$)).toString());
            }
            if (c.getMethod("equals", Object.class).getDeclaringClass() == Object.class) {
                throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Type '", "' cannot be used in a ", " operation because it "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c.getCanonicalName(), name}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"does not implement a proper equals() method."})).s((Seq)Nil$.MODULE$)).toString());
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private TypeCheckUtils$() {
        MODULE$ = this;
    }
}

