/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils.ordered;

import java.io.IOException;
import java.math.BigInteger;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.ParameterlessTypeSerializerConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.typeutils.ordered.OrderedBytes;

@Internal
public final class OrderedBigIntSerializer
extends TypeSerializer<BigInteger> {
    private static final long serialVersionUID = 1L;
    public static final OrderedBigIntSerializer ASC_INSTANCE = new OrderedBigIntSerializer(OrderedBytes.Order.ASCENDING);
    public static final OrderedBigIntSerializer DESC_INSTANCE = new OrderedBigIntSerializer(OrderedBytes.Order.DESCENDING);
    private final OrderedBytes orderedBytes;
    private final OrderedBytes.Order ord;
    private String serializationFormatIdentifier;

    private OrderedBigIntSerializer(OrderedBytes.Order ord) {
        this.ord = ord;
        this.orderedBytes = new OrderedBytes();
    }

    @Override
    public boolean isImmutableType() {
        return true;
    }

    @Override
    public TypeSerializer<BigInteger> duplicate() {
        return new OrderedBigIntSerializer(this.ord);
    }

    @Override
    public BigInteger createInstance() {
        return BigInteger.ZERO;
    }

    @Override
    public BigInteger copy(BigInteger from) {
        return from;
    }

    @Override
    public BigInteger copy(BigInteger from, BigInteger reuse) {
        return from;
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(BigInteger record, DataOutputView target) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException("The record must not be null.");
        }
        this.orderedBytes.encodeBigInteger(target, record, this.ord);
    }

    @Override
    public BigInteger deserialize(DataInputView source) throws IOException {
        return this.orderedBytes.decodeBigInteger(source, this.ord);
    }

    @Override
    public BigInteger deserialize(BigInteger reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.orderedBytes.encodeBigInteger(target, this.orderedBytes.decodeBigInteger(source, this.ord), this.ord);
    }

    @Override
    public boolean equals(Object obj) {
        if (this.canEqual(obj)) {
            OrderedBigIntSerializer other = (OrderedBigIntSerializer)obj;
            return this.ord.equals((Object)other.ord);
        }
        return false;
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof OrderedBigIntSerializer;
    }

    @Override
    public int hashCode() {
        return this.getSerializationFormatIdentifier().hashCode();
    }

    @Override
    public TypeSerializerConfigSnapshot snapshotConfiguration() {
        return new ParameterlessTypeSerializerConfig(this.getSerializationFormatIdentifier());
    }

    @Override
    public CompatibilityResult<BigInteger> ensureCompatibility(TypeSerializerConfigSnapshot configSnapshot) {
        if (configSnapshot instanceof ParameterlessTypeSerializerConfig && this.isCompatibleSerializationFormatIdentifier(((ParameterlessTypeSerializerConfig)configSnapshot).getSerializationFormatIdentifier())) {
            return CompatibilityResult.compatible();
        }
        return CompatibilityResult.requiresMigration();
    }

    private String getSerializationFormatIdentifier() {
        String id = this.serializationFormatIdentifier;
        if (id == null) {
            this.serializationFormatIdentifier = id = this.getClass().getCanonicalName() + "," + (Object)((Object)this.ord);
        }
        return id;
    }

    private boolean isCompatibleSerializationFormatIdentifier(String identifier) {
        return identifier.equals(this.getSerializationFormatIdentifier());
    }
}

