/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils.ordered;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.typeutils.ordered.OrderedBytes;

@Internal
public final class OrderedBooleanSerializer
extends TypeSerializerSingleton<Boolean> {
    private static final long serialVersionUID = 1L;
    public static final OrderedBooleanSerializer ASC_INSTANCE = new OrderedBooleanSerializer(OrderedBytes.Order.ASCENDING);
    public static final OrderedBooleanSerializer DESC_INSTANCE = new OrderedBooleanSerializer(OrderedBytes.Order.DESCENDING);
    private static final Boolean FALSE = Boolean.FALSE;
    private static final OrderedBytes orderedBytes = new OrderedBytes();
    private final OrderedBytes.Order ord;

    private OrderedBooleanSerializer(OrderedBytes.Order ord) {
        this.ord = ord;
    }

    @Override
    public boolean isImmutableType() {
        return true;
    }

    @Override
    public Boolean createInstance() {
        return FALSE;
    }

    @Override
    public Boolean copy(Boolean from) {
        return from;
    }

    @Override
    public Boolean copy(Boolean from, Boolean reuse) {
        return from;
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public void serialize(Boolean record, DataOutputView target) throws IOException {
        orderedBytes.encodeByte(target, (byte)(record != false ? 1 : 0), this.ord);
    }

    @Override
    public Boolean deserialize(DataInputView source) throws IOException {
        byte v = orderedBytes.decodeByte(source, this.ord);
        return v != 0;
    }

    @Override
    public Boolean deserialize(Boolean reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        orderedBytes.encodeByte(target, orderedBytes.decodeByte(source, this.ord), this.ord);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof OrderedBooleanSerializer;
    }
}

