/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils.ordered;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.ParameterlessTypeSerializerConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.typeutils.ordered.OrderedBytes;

@Internal
public final class OrderedBytePrimitiveArraySerializer
extends TypeSerializer<byte[]> {
    private static final long serialVersionUID = 1L;
    private static final byte[] EMPTY = new byte[0];
    public static final OrderedBytePrimitiveArraySerializer ASC_INSTANCE = new OrderedBytePrimitiveArraySerializer(OrderedBytes.Order.ASCENDING);
    public static final OrderedBytePrimitiveArraySerializer DESC_INSTANCE = new OrderedBytePrimitiveArraySerializer(OrderedBytes.Order.DESCENDING);
    private final OrderedBytes orderedBytes;
    private final OrderedBytes.Order ord;
    private String serializationFormatIdentifier;

    private OrderedBytePrimitiveArraySerializer(OrderedBytes.Order ord) {
        this.ord = ord;
        this.orderedBytes = new OrderedBytes();
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public TypeSerializer<byte[]> duplicate() {
        return new OrderedBytePrimitiveArraySerializer(this.ord);
    }

    @Override
    public byte[] createInstance() {
        return EMPTY;
    }

    @Override
    public byte[] copy(byte[] from) {
        byte[] copy2 = new byte[from.length];
        System.arraycopy(from, 0, copy2, 0, from.length);
        return copy2;
    }

    @Override
    public byte[] copy(byte[] from, byte[] reuse) {
        return this.copy(from);
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(byte[] record, DataOutputView target) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException("The record must not be null.");
        }
        this.orderedBytes.encodeByteArray(target, record, this.ord);
    }

    @Override
    public byte[] deserialize(DataInputView source) throws IOException {
        return this.orderedBytes.decodeByteArray(source, this.ord);
    }

    @Override
    public byte[] deserialize(byte[] reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.orderedBytes.encodeByteArray(target, this.orderedBytes.decodeByteArray(source, this.ord), this.ord);
    }

    @Override
    public boolean equals(Object obj) {
        if (this.canEqual(obj)) {
            OrderedBytePrimitiveArraySerializer other = (OrderedBytePrimitiveArraySerializer)obj;
            return this.ord.equals((Object)other.ord);
        }
        return false;
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof OrderedBytePrimitiveArraySerializer;
    }

    @Override
    public int hashCode() {
        return this.getSerializationFormatIdentifier().hashCode();
    }

    @Override
    public TypeSerializerConfigSnapshot snapshotConfiguration() {
        return new ParameterlessTypeSerializerConfig(this.getSerializationFormatIdentifier());
    }

    @Override
    public CompatibilityResult<byte[]> ensureCompatibility(TypeSerializerConfigSnapshot configSnapshot) {
        if (configSnapshot instanceof ParameterlessTypeSerializerConfig && this.isCompatibleSerializationFormatIdentifier(((ParameterlessTypeSerializerConfig)configSnapshot).getSerializationFormatIdentifier())) {
            return CompatibilityResult.compatible();
        }
        return CompatibilityResult.requiresMigration();
    }

    private String getSerializationFormatIdentifier() {
        String id = this.serializationFormatIdentifier;
        if (id == null) {
            this.serializationFormatIdentifier = id = this.getClass().getCanonicalName() + "," + (Object)((Object)this.ord);
        }
        return id;
    }

    private boolean isCompatibleSerializationFormatIdentifier(String identifier) {
        return identifier.equals(this.getSerializationFormatIdentifier());
    }
}

