/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils.ordered;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.typeutils.ordered.OrderedBytes;

@Internal
public final class OrderedByteSerializer
extends TypeSerializerSingleton<Byte> {
    private static final long serialVersionUID = 1L;
    public static final OrderedByteSerializer ASC_INSTANCE = new OrderedByteSerializer(OrderedBytes.Order.ASCENDING);
    public static final OrderedByteSerializer DESC_INSTANCE = new OrderedByteSerializer(OrderedBytes.Order.DESCENDING);
    private static final Byte ZERO = 0;
    private static final OrderedBytes orderedBytes = new OrderedBytes();
    private final OrderedBytes.Order ord;

    private OrderedByteSerializer(OrderedBytes.Order ord) {
        this.ord = ord;
    }

    @Override
    public boolean isImmutableType() {
        return true;
    }

    @Override
    public Byte createInstance() {
        return ZERO;
    }

    @Override
    public Byte copy(Byte from) {
        return from;
    }

    @Override
    public Byte copy(Byte from, Byte reuse) {
        return from;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public void serialize(Byte record, DataOutputView target) throws IOException {
        orderedBytes.encodeByte(target, record, this.ord);
    }

    @Override
    public Byte deserialize(DataInputView source) throws IOException {
        return orderedBytes.decodeByte(source, this.ord);
    }

    @Override
    public Byte deserialize(Byte reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        orderedBytes.encodeByte(target, orderedBytes.decodeByte(source, this.ord), this.ord);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof OrderedByteSerializer;
    }
}

