/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils.ordered;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.Decimal;

public final class OrderedBytes
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private static final byte TERM = 0;
    private static final byte NEG_LARGE = 8;
    private static final byte NEG_MED_MIN = 9;
    private static final byte NEG_MED_MAX = 19;
    private static final byte NEG_SMALL = 20;
    private static final byte ZERO = 21;
    private static final byte POS_SMALL = 22;
    private static final byte POS_MED_MIN = 23;
    private static final byte POS_MED_MAX = 33;
    private static final byte POS_LARGE = 34;
    private static final BigDecimal E8 = BigDecimal.valueOf(1.0E8);
    private static final BigDecimal E32 = BigDecimal.valueOf(1.0E32);
    private static final BigDecimal EN2 = BigDecimal.valueOf(0.01);
    private static final BigDecimal EN10 = BigDecimal.valueOf(1.0E-10);
    private static final MathContext DEFAULT_MATH_CONTEXT = new MathContext(38, RoundingMode.HALF_UP);
    private static final int BUFFER_SIZE = 256;
    private transient byte[] reuseBuffer;
    private transient ByteArrayOutputStreamWithPos reuseBaos;

    private static BigDecimal normalize(BigDecimal val) {
        return null == val ? null : val.stripTrailingZeros().round(DEFAULT_MATH_CONTEXT);
    }

    public int encodeBigDecimal(DataOutputView target, BigDecimal val, Order ord) throws IOException {
        if (BigDecimal.ZERO.compareTo(val) == 0) {
            target.writeByte(ord.apply((byte)21));
            return 1;
        }
        BigDecimal abs = val.abs();
        int len = BigDecimal.ONE.compareTo(abs) <= 0 ? this.encodeBigDecimalLarge(target, OrderedBytes.normalize(val), ord) : this.encodeBigDecimalSmall(target, OrderedBytes.normalize(val), ord);
        return len;
    }

    private int encodeBigDecimalSmall(DataOutputView target, BigDecimal val, Order ord) throws IOException {
        BigDecimal abs = val.abs();
        assert (BigDecimal.ZERO.compareTo(abs) < 0 && BigDecimal.ONE.compareTo(abs) > 0);
        boolean isNeg = val.signum() == -1;
        int e2 = 0;
        int length = 0;
        if (isNeg) {
            target.writeByte(ord.apply((byte)20));
        } else {
            target.writeByte(ord.apply((byte)22));
        }
        ++length;
        while (abs.compareTo(EN10) < 0) {
            abs = abs.movePointRight(8);
            e2 += 4;
        }
        while (abs.compareTo(EN2) < 0) {
            abs = abs.movePointRight(2);
            ++e2;
        }
        length += this.encodeInt(target, e2, OrderedBytes.getCompositeOrder(!isNeg ? Order.DESCENDING : Order.ASCENDING, ord));
        Order compOrd = OrderedBytes.getCompositeOrder(isNeg ? Order.DESCENDING : Order.ASCENDING, ord);
        for (int i = 0; i < 18 && abs.compareTo(BigDecimal.ZERO) != 0; ++i) {
            abs = abs.movePointRight(2);
            int d = abs.intValue();
            target.writeByte(compOrd.apply((byte)(d & 0xFF)));
            abs = abs.subtract(BigDecimal.valueOf(d));
            ++length;
        }
        return length;
    }

    private int encodeBigDecimalLarge(DataOutputView target, BigDecimal val, Order ord) throws IOException {
        int e2;
        BigDecimal abs = val.abs();
        boolean isNeg = val.signum() == -1;
        int length = 0;
        for (e2 = 0; abs.compareTo(E32) >= 0 && e2 <= 350; e2 += 16) {
            abs = abs.movePointLeft(32);
        }
        while (abs.compareTo(E8) >= 0 && e2 <= 350) {
            abs = abs.movePointLeft(8);
            e2 += 4;
        }
        while (abs.compareTo(BigDecimal.ONE) >= 0 && e2 <= 350) {
            abs = abs.movePointLeft(2);
            ++e2;
        }
        Order compOrd = OrderedBytes.getCompositeOrder(isNeg ? Order.DESCENDING : Order.ASCENDING, ord);
        if (e2 > 10) {
            if (isNeg) {
                target.writeByte(ord.apply((byte)8));
            } else {
                target.writeByte(ord.apply((byte)34));
            }
            ++length;
            length += this.encodeInt(target, e2, compOrd);
        } else {
            if (isNeg) {
                target.writeByte(ord.apply((byte)(19 - e2)));
            } else {
                target.writeByte(ord.apply((byte)(23 + e2)));
            }
            ++length;
        }
        for (int i = 0; i < 18 && abs.compareTo(BigDecimal.ZERO) != 0; ++i) {
            abs = abs.movePointRight(2);
            int d = abs.intValue();
            target.writeByte(compOrd.apply((byte)(d & 0xFF)));
            abs = abs.subtract(BigDecimal.valueOf(d));
            ++length;
        }
        return length;
    }

    public BigDecimal decodeBigDecimal(DataInputView source, Order ord) throws IOException {
        byte header = ord.apply(source.readByte());
        if (header == 8) {
            int e2 = this.decodeInt(source, OrderedBytes.getOppositeOrder(ord));
            return this.decodeSignificand(source, e2, OrderedBytes.getOppositeOrder(ord)).negate();
        }
        if (header >= 9 && header <= 19) {
            int e3 = 19 - header;
            return this.decodeSignificand(source, e3, OrderedBytes.getOppositeOrder(ord)).negate();
        }
        if (header == 20) {
            int e4 = -this.decodeInt(source, ord);
            return this.decodeSignificand(source, e4, OrderedBytes.getOppositeOrder(ord)).negate();
        }
        if (header == 21) {
            return BigDecimal.ZERO;
        }
        if (header == 22) {
            int e5 = -this.decodeInt(source, OrderedBytes.getOppositeOrder(ord));
            return this.decodeSignificand(source, e5, ord);
        }
        if (header >= 23 && header <= 33) {
            int e6 = header - 23;
            return this.decodeSignificand(source, e6, ord);
        }
        if (header == 34) {
            int e7 = this.decodeInt(source, ord);
            return this.decodeSignificand(source, e7, ord);
        }
        throw new IllegalArgumentException("unexpected value in first byte: 0x" + Long.toHexString(header));
    }

    private BigDecimal decodeSignificand(DataInputView source, int e2, Order ord) throws IOException {
        int len;
        BigDecimal m = BigDecimal.ZERO;
        --e2;
        if (this.reuseBuffer == null) {
            this.reuseBuffer = new byte[256];
        }
        while ((len = source.read(this.reuseBuffer)) != -1) {
            ord.apply(this.reuseBuffer, 0, len);
            for (int i = 0; i < len; ++i) {
                m = m.add(new BigDecimal(BigInteger.ONE, e2 * -2).multiply(BigDecimal.valueOf(this.reuseBuffer[i] & 0xFF)));
                --e2;
            }
        }
        return OrderedBytes.normalize(m);
    }

    private static Order getCompositeOrder(Order ord1, Order ord2) {
        if (ord1 == ord2) {
            return Order.ASCENDING;
        }
        return Order.DESCENDING;
    }

    private static Order getOppositeOrder(Order ord) {
        if (ord == Order.DESCENDING) {
            return Order.ASCENDING;
        }
        return Order.DESCENDING;
    }

    public int encodeDecimal(DataOutputView target, Decimal val, Order ord) throws IOException {
        return this.encodeBigDecimal(target, val.toBigDecimal(), ord);
    }

    public Decimal decodeDecimal(DataInputView source, int precision, int scale, Order ord) throws IOException {
        BigDecimal bd = this.decodeBigDecimal(source, ord);
        return Decimal.fromBigDecimal(bd, precision, scale);
    }

    public int encodeBigInteger(DataOutputView target, BigInteger val, Order ord) throws IOException {
        int sig = val.signum();
        byte[] valByteArray = val.toByteArray();
        int length = this.encodeInt(target, sig == -1 ? -valByteArray.length : valByteArray.length, ord);
        target.write(ord.apply(valByteArray));
        return length + valByteArray.length;
    }

    public BigInteger decodeBigInteger(DataInputView source, Order ord) throws IOException {
        int len;
        source.skipBytes(4);
        if (this.reuseBuffer == null) {
            this.reuseBuffer = new byte[256];
        }
        if (this.reuseBaos == null) {
            this.reuseBaos = new ByteArrayOutputStreamWithPos();
        }
        this.reuseBaos.reset();
        while ((len = source.read(this.reuseBuffer)) != -1) {
            this.reuseBaos.write(this.reuseBuffer, 0, len);
        }
        return new BigInteger(ord.apply(this.reuseBaos.toByteArray()));
    }

    public int encodeBinaryString(DataOutputView target, BinaryString val, Order ord) throws IOException {
        byte[] copy2;
        if (ord == Order.ASCENDING) {
            copy2 = val.getBytes();
        } else {
            copy2 = new byte[val.numBytes()];
            val.copyTo(copy2);
        }
        target.write(ord.apply(copy2));
        int len = copy2.length;
        if (ord == Order.DESCENDING) {
            target.writeByte(ord.apply((byte)0));
            ++len;
        }
        return len;
    }

    public BinaryString decodeBinaryString(DataInputView source, Order ord) throws IOException {
        int len;
        if (this.reuseBuffer == null) {
            this.reuseBuffer = new byte[256];
        }
        if (this.reuseBaos == null) {
            this.reuseBaos = new ByteArrayOutputStreamWithPos();
        }
        this.reuseBaos.reset();
        while ((len = source.read(this.reuseBuffer)) != -1) {
            this.reuseBaos.write(this.reuseBuffer, 0, len);
        }
        if (ord == Order.DESCENDING) {
            this.reuseBaos.setPosition(this.reuseBaos.size() - 1);
        }
        return BinaryString.fromBytes(ord.apply(this.reuseBaos.toByteArray()));
    }

    public int encodeString(DataOutputView target, String val, Order ord) throws IOException {
        byte[] bytes = val.getBytes(UTF8);
        target.write(ord.apply(bytes));
        int len = bytes.length;
        if (ord == Order.DESCENDING) {
            target.writeByte(ord.apply((byte)0));
            ++len;
        }
        return len;
    }

    public String decodeString(DataInputView source, Order ord) throws IOException {
        int len;
        if (this.reuseBuffer == null) {
            this.reuseBuffer = new byte[256];
        }
        if (this.reuseBaos == null) {
            this.reuseBaos = new ByteArrayOutputStreamWithPos();
        }
        this.reuseBaos.reset();
        while ((len = source.read(this.reuseBuffer)) != -1) {
            this.reuseBaos.write(this.reuseBuffer, 0, len);
        }
        if (ord == Order.DESCENDING) {
            this.reuseBaos.setPosition(this.reuseBaos.size() - 1);
        }
        return new String(ord.apply(this.reuseBaos.toByteArray()), UTF8);
    }

    public int encodeByteArray(DataOutputView target, byte[] val, int voff, int vlen, Order ord) throws IOException {
        int remaining;
        if (ord == Order.ASCENDING) {
            target.write(val, voff, vlen);
            return vlen;
        }
        if (this.reuseBuffer == null) {
            this.reuseBuffer = new byte[256];
        }
        for (remaining = vlen; remaining > 256; remaining -= 256) {
            System.arraycopy(val, voff, this.reuseBuffer, 0, 256);
            ord.apply(this.reuseBuffer, 0, 256);
            target.write(this.reuseBuffer, 0, 256);
            voff += 256;
        }
        System.arraycopy(val, voff, this.reuseBuffer, 0, remaining);
        ord.apply(this.reuseBuffer, 0, remaining);
        target.write(this.reuseBuffer, 0, remaining);
        target.writeByte(ord.apply((byte)0));
        return vlen + 1;
    }

    public int encodeByteArray(DataOutputView target, byte[] val, Order ord) throws IOException {
        return this.encodeByteArray(target, val, 0, val.length, ord);
    }

    public byte[] decodeByteArray(DataInputView source, Order ord) throws IOException {
        int len;
        if (this.reuseBuffer == null) {
            this.reuseBuffer = new byte[256];
        }
        if (this.reuseBaos == null) {
            this.reuseBaos = new ByteArrayOutputStreamWithPos();
        }
        this.reuseBaos.reset();
        while ((len = source.read(this.reuseBuffer)) != -1) {
            this.reuseBaos.write(this.reuseBuffer, 0, len);
        }
        if (ord == Order.DESCENDING) {
            this.reuseBaos.setPosition(this.reuseBaos.size() - 1);
        }
        return ord.apply(this.reuseBaos.toByteArray());
    }

    public int encodeByte(DataOutputView target, byte val, Order ord) throws IOException {
        byte ret = (byte)(val ^ 0x80);
        target.writeByte(ord.apply(ret));
        return 1;
    }

    public byte decodeByte(DataInputView source, Order ord) throws IOException {
        return (byte)((ord.apply(source.readByte()) ^ 0x80) & 0xFF);
    }

    public int encodeShort(DataOutputView target, short val, Order ord) throws IOException {
        target.writeByte(ord.apply((byte)(val >> 8 ^ 0x80)));
        target.writeByte(ord.apply((byte)val));
        return 2;
    }

    public short decodeShort(DataInputView source, Order ord) throws IOException {
        short val = (short)((ord.apply(source.readByte()) ^ 0x80) & 0xFF);
        val = (short)(val << 8 | ord.apply(source.readByte()) & 0xFF);
        return val;
    }

    public int encodeInt(DataOutputView target, int val, Order ord) throws IOException {
        target.writeByte(ord.apply((byte)(val >> 24 ^ 0x80)));
        target.writeByte(ord.apply((byte)(val >> 16)));
        target.writeByte(ord.apply((byte)(val >> 8)));
        target.writeByte(ord.apply((byte)val));
        return 4;
    }

    public int decodeInt(DataInputView source, Order ord) throws IOException {
        int val = (ord.apply(source.readByte()) ^ 0x80) & 0xFF;
        for (int i = 1; i < 4; ++i) {
            val = val << 8 | ord.apply(source.readByte()) & 0xFF;
        }
        return val;
    }

    public int encodeLong(DataOutputView target, long val, Order ord) throws IOException {
        target.writeByte(ord.apply((byte)(val >> 56 ^ 0x80L)));
        target.writeByte(ord.apply((byte)(val >> 48)));
        target.writeByte(ord.apply((byte)(val >> 40)));
        target.writeByte(ord.apply((byte)(val >> 32)));
        target.writeByte(ord.apply((byte)(val >> 24)));
        target.writeByte(ord.apply((byte)(val >> 16)));
        target.writeByte(ord.apply((byte)(val >> 8)));
        target.writeByte(ord.apply((byte)val));
        return 8;
    }

    public long decodeLong(DataInputView source, Order ord) throws IOException {
        long val = (ord.apply(source.readByte()) ^ 0x80) & 0xFF;
        for (int i = 1; i < 8; ++i) {
            val = val << 8 | (long)(ord.apply(source.readByte()) & 0xFF);
        }
        return val;
    }

    public int encodeFloat(DataOutputView target, float val, Order ord) throws IOException {
        int i = Float.floatToIntBits(val);
        i ^= i >> 31 | Integer.MIN_VALUE;
        target.writeByte(ord.apply((byte)(i >> 24)));
        target.writeByte(ord.apply((byte)(i >> 16)));
        target.writeByte(ord.apply((byte)(i >> 8)));
        target.writeByte(ord.apply((byte)i));
        return 4;
    }

    public float decodeFloat(DataInputView source, Order ord) throws IOException {
        int val = ord.apply(source.readByte()) & 0xFF;
        for (int i = 1; i < 4; ++i) {
            val = val << 8 | ord.apply(source.readByte()) & 0xFF;
        }
        val ^= ~val >> 31 | Integer.MIN_VALUE;
        return Float.intBitsToFloat(val);
    }

    public int encodeDouble(DataOutputView target, double val, Order ord) throws IOException {
        long lng = Double.doubleToLongBits(val);
        lng ^= lng >> 63 | Long.MIN_VALUE;
        target.writeByte(ord.apply((byte)(lng >> 56)));
        target.writeByte(ord.apply((byte)(lng >> 48)));
        target.writeByte(ord.apply((byte)(lng >> 40)));
        target.writeByte(ord.apply((byte)(lng >> 32)));
        target.writeByte(ord.apply((byte)(lng >> 24)));
        target.writeByte(ord.apply((byte)(lng >> 16)));
        target.writeByte(ord.apply((byte)(lng >> 8)));
        target.writeByte(ord.apply((byte)lng));
        return 8;
    }

    public double decodeDouble(DataInputView source, Order ord) throws IOException {
        long val = ord.apply(source.readByte()) & 0xFF;
        for (int i = 1; i < 8; ++i) {
            val = (val << 8) + (long)(ord.apply(source.readByte()) & 0xFF);
        }
        val ^= (val ^ 0xFFFFFFFFFFFFFFFFL) >> 63 | Long.MIN_VALUE;
        return Double.longBitsToDouble(val);
    }

    public int encodeChar(DataOutputView target, char val, Order ord) throws IOException {
        target.writeByte(ord.apply((byte)(val >> 8)));
        target.writeByte(ord.apply((byte)val));
        return 2;
    }

    public char decodeChar(DataInputView source, Order ord) throws IOException {
        char val = (char)(ord.apply(source.readByte()) & 0xFF);
        val = (char)(val << 8 | ord.apply(source.readByte()) & 0xFF);
        return val;
    }

    public static enum Order {
        ASCENDING{

            @Override
            public int cmp(int cmp) {
                return cmp;
            }

            @Override
            public byte apply(byte val) {
                return val;
            }

            @Override
            public byte[] apply(byte[] val) {
                return val;
            }

            @Override
            public void apply(byte[] val, int offset, int length) {
            }

            public String toString() {
                return "ASCENDING";
            }
        }
        ,
        DESCENDING{
            private static final byte MASK = -1;

            @Override
            public int cmp(int cmp) {
                return -1 * cmp;
            }

            @Override
            public byte apply(byte val) {
                return ~val;
            }

            @Override
            public byte[] apply(byte[] val) {
                int i = 0;
                while (i < val.length) {
                    int n = i++;
                    val[n] = ~val[n];
                }
                return val;
            }

            @Override
            public void apply(byte[] val, int offset, int length) {
                for (int i = 0; i < length; ++i) {
                    int n = offset + i;
                    val[n] = ~val[n];
                }
            }

            public String toString() {
                return "DESCENDING";
            }
        };


        public abstract int cmp(int var1);

        public abstract byte apply(byte var1);

        public abstract byte[] apply(byte[] var1);

        public abstract void apply(byte[] var1, int var2, int var3);
    }
}

