/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils.ordered;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.typeutils.ordered.OrderedBytes;

@Internal
public final class OrderedFloatSerializer
extends TypeSerializerSingleton<Float> {
    private static final long serialVersionUID = 1L;
    public static final OrderedFloatSerializer ASC_INSTANCE = new OrderedFloatSerializer(OrderedBytes.Order.ASCENDING);
    public static final OrderedFloatSerializer DESC_INSTANCE = new OrderedFloatSerializer(OrderedBytes.Order.DESCENDING);
    private static final Float ZERO = Float.valueOf(0.0f);
    private static final OrderedBytes orderedBytes = new OrderedBytes();
    private final OrderedBytes.Order ord;

    private OrderedFloatSerializer(OrderedBytes.Order ord) {
        this.ord = ord;
    }

    @Override
    public boolean isImmutableType() {
        return true;
    }

    @Override
    public Float createInstance() {
        return ZERO;
    }

    @Override
    public Float copy(Float from) {
        return from;
    }

    @Override
    public Float copy(Float from, Float reuse) {
        return from;
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public void serialize(Float record, DataOutputView target) throws IOException {
        orderedBytes.encodeFloat(target, record.floatValue(), this.ord);
    }

    @Override
    public Float deserialize(DataInputView source) throws IOException {
        return Float.valueOf(orderedBytes.decodeFloat(source, this.ord));
    }

    @Override
    public Float deserialize(Float reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        orderedBytes.encodeFloat(target, orderedBytes.decodeFloat(source, this.ord), this.ord);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof OrderedFloatSerializer;
    }
}

