/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils.ordered;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.typeutils.ordered.OrderedBytes;

@Internal
public final class OrderedIntSerializer
extends TypeSerializerSingleton<Integer> {
    private static final long serialVersionUID = 1L;
    public static final OrderedIntSerializer ASC_INSTANCE = new OrderedIntSerializer(OrderedBytes.Order.ASCENDING);
    public static final OrderedIntSerializer DESC_INSTANCE = new OrderedIntSerializer(OrderedBytes.Order.DESCENDING);
    private static final Integer ZERO = 0;
    private static final OrderedBytes orderedBytes = new OrderedBytes();
    private final OrderedBytes.Order ord;

    private OrderedIntSerializer(OrderedBytes.Order ord) {
        this.ord = ord;
    }

    @Override
    public boolean isImmutableType() {
        return true;
    }

    @Override
    public Integer createInstance() {
        return ZERO;
    }

    @Override
    public Integer copy(Integer from) {
        return from;
    }

    @Override
    public Integer copy(Integer from, Integer reuse) {
        return from;
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public void serialize(Integer record, DataOutputView target) throws IOException {
        orderedBytes.encodeInt(target, record, this.ord);
    }

    @Override
    public Integer deserialize(DataInputView source) throws IOException {
        return orderedBytes.decodeInt(source, this.ord);
    }

    @Override
    public Integer deserialize(Integer reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        orderedBytes.encodeInt(target, orderedBytes.decodeInt(source, this.ord), this.ord);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof OrderedIntSerializer;
    }
}

