/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils.ordered;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.typeutils.ordered.OrderedBytes;

@Internal
public final class OrderedLongSerializer
extends TypeSerializerSingleton<Long> {
    private static final long serialVersionUID = 1L;
    public static final OrderedLongSerializer ASC_INSTANCE = new OrderedLongSerializer(OrderedBytes.Order.ASCENDING);
    public static final OrderedLongSerializer DESC_INSTANCE = new OrderedLongSerializer(OrderedBytes.Order.DESCENDING);
    private static final Long ZERO = 0L;
    private static final OrderedBytes orderedBytes = new OrderedBytes();
    private final OrderedBytes.Order ord;

    private OrderedLongSerializer(OrderedBytes.Order ord) {
        this.ord = ord;
    }

    @Override
    public boolean isImmutableType() {
        return true;
    }

    @Override
    public Long createInstance() {
        return ZERO;
    }

    @Override
    public Long copy(Long from) {
        return from;
    }

    @Override
    public Long copy(Long from, Long reuse) {
        return from;
    }

    @Override
    public int getLength() {
        return 8;
    }

    @Override
    public void serialize(Long record, DataOutputView target) throws IOException {
        orderedBytes.encodeLong(target, record, this.ord);
    }

    @Override
    public Long deserialize(DataInputView source) throws IOException {
        return orderedBytes.decodeLong(source, this.ord);
    }

    @Override
    public Long deserialize(Long reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        orderedBytes.encodeLong(target, orderedBytes.decodeLong(source, this.ord), this.ord);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof OrderedLongSerializer;
    }
}

