/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils.ordered;

import java.io.IOException;
import java.sql.Date;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.typeutils.ordered.OrderedBytes;

@Internal
public final class OrderedSqlDateSerializer
extends TypeSerializerSingleton<Date> {
    private static final long serialVersionUID = 1L;
    public static final OrderedSqlDateSerializer ASC_INSTANCE = new OrderedSqlDateSerializer(OrderedBytes.Order.ASCENDING);
    public static final OrderedSqlDateSerializer DESC_INSTANCE = new OrderedSqlDateSerializer(OrderedBytes.Order.DESCENDING);
    private static final OrderedBytes orderedBytes = new OrderedBytes();
    private final OrderedBytes.Order ord;

    private OrderedSqlDateSerializer(OrderedBytes.Order ord) {
        this.ord = ord;
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public Date createInstance() {
        return new Date(0L);
    }

    @Override
    public Date copy(Date from) {
        if (from == null) {
            return null;
        }
        return new Date(from.getTime());
    }

    @Override
    public Date copy(Date from, Date reuse) {
        if (from == null) {
            return null;
        }
        reuse.setTime(from.getTime());
        return reuse;
    }

    @Override
    public int getLength() {
        return 8;
    }

    @Override
    public void serialize(Date record, DataOutputView target) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException("The record must not be null.");
        }
        orderedBytes.encodeLong(target, record.getTime(), this.ord);
    }

    @Override
    public Date deserialize(DataInputView source) throws IOException {
        long v = orderedBytes.decodeLong(source, this.ord);
        return new Date(v);
    }

    @Override
    public Date deserialize(Date reuse, DataInputView source) throws IOException {
        long v = orderedBytes.decodeLong(source, this.ord);
        reuse.setTime(v);
        return reuse;
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        orderedBytes.encodeLong(target, orderedBytes.decodeLong(source, this.ord), this.ord);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof OrderedSqlDateSerializer;
    }
}

