/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.typeutils.ordered;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.typeutils.ordered.OrderedSqlDateSerializer;
import org.apache.flink.table.typeutils.ordered.OrderedSqlTimeSerializer;
import org.apache.flink.table.typeutils.ordered.OrderedSqlTimestampSerializer;
import org.apache.flink.util.Preconditions;

@Internal
public class OrderedSqlTimeTypeInfo<T>
extends TypeInformation<T> {
    private static final long serialVersionUID = -132955295409131880L;
    public static final OrderedSqlTimeTypeInfo<Date> ASC_DATE = new OrderedSqlTimeTypeInfo<Date>(Date.class, OrderedSqlDateSerializer.ASC_INSTANCE);
    public static final OrderedSqlTimeTypeInfo<Date> DESC_DATE = new OrderedSqlTimeTypeInfo<Date>(Date.class, OrderedSqlDateSerializer.DESC_INSTANCE);
    public static final OrderedSqlTimeTypeInfo<Time> ASC_TIME = new OrderedSqlTimeTypeInfo<Time>(Time.class, OrderedSqlTimeSerializer.ASC_INSTANCE);
    public static final OrderedSqlTimeTypeInfo<Time> DESC_TIME = new OrderedSqlTimeTypeInfo<Time>(Time.class, OrderedSqlTimeSerializer.DESC_INSTANCE);
    public static final OrderedSqlTimeTypeInfo<Timestamp> ASC_TIMESTAMP = new OrderedSqlTimeTypeInfo<Timestamp>(Timestamp.class, OrderedSqlTimestampSerializer.ASC_INSTANCE);
    public static final OrderedSqlTimeTypeInfo<Timestamp> DESC_TIMESTAMP = new OrderedSqlTimeTypeInfo<Timestamp>(Timestamp.class, OrderedSqlTimestampSerializer.DESC_INSTANCE);
    private final Class<T> clazz;
    private final TypeSerializer<T> serializer;

    protected OrderedSqlTimeTypeInfo(Class<T> clazz, TypeSerializer<T> serializer) {
        this.clazz = Preconditions.checkNotNull(clazz);
        this.serializer = Preconditions.checkNotNull(serializer);
    }

    @Override
    public boolean isBasicType() {
        return false;
    }

    @Override
    public boolean isTupleType() {
        return false;
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public int getTotalFields() {
        return 1;
    }

    @Override
    public Class<T> getTypeClass() {
        return this.clazz;
    }

    @Override
    public boolean isKeyType() {
        return true;
    }

    @Override
    public TypeSerializer<T> createSerializer(ExecutionConfig executionConfig) {
        return this.serializer;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clazz, this.serializer);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof OrderedSqlTimeTypeInfo;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof OrderedSqlTimeTypeInfo) {
            OrderedSqlTimeTypeInfo other = (OrderedSqlTimeTypeInfo)obj;
            return other.canEqual(this) && this.clazz == other.clazz && this.serializer.equals(other.serializer);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.clazz.getSimpleName();
    }
}

