/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.util;

import java.util.List;
import org.apache.flink.table.api.BatchTableEnvironment;
import org.apache.flink.table.plan.nodes.exec.BatchExecNode;
import org.apache.flink.table.plan.nodes.exec.ExecNode;
import org.apache.flink.table.plan.nodes.exec.batch.BatchExecNodeVisitorImpl;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecCalc;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecExchange;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecHashJoinBase;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecSort;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecSortMergeJoinBase;
import org.apache.flink.table.plan.nodes.process.DAGProcessContext;
import org.apache.flink.table.plan.nodes.process.DAGProcessor;

public class CalcOutputBinaryRowProcessor
extends BatchExecNodeVisitorImpl
implements DAGProcessor {
    @Override
    public List<ExecNode<?, ?>> process(List<ExecNode<?, ?>> sinkNodes, DAGProcessContext context) {
        List<BatchExecNode<?>> batchExecNodes = DAGProcessor.getNonSinkBatchExecNodes(sinkNodes);
        batchExecNodes.forEach(b -> b.accept(this));
        return sinkNodes;
    }

    @Override
    public void visit(BatchExecExchange exchange) {
        super.visit(exchange);
        this.enableCalcOutputBinaryRow(exchange.getInputNodes().get(0));
    }

    @Override
    public void visit(BatchExecSort sort) {
        super.visit(sort);
        this.enableCalcOutputBinaryRow(sort.getInputNodes().get(0));
    }

    @Override
    public void visit(BatchExecSortMergeJoinBase join) {
        super.visit(join);
        if (!join.leftSorted()) {
            this.enableCalcOutputBinaryRow(join.getInputNodes().get(0));
        }
        if (!join.rightSorted()) {
            this.enableCalcOutputBinaryRow(join.getInputNodes().get(1));
        }
    }

    @Override
    public void visit(BatchExecHashJoinBase join) {
        super.visit(join);
        if (join.leftIsBuild()) {
            this.enableCalcOutputBinaryRow(join.getInputNodes().get(0));
        } else {
            this.enableCalcOutputBinaryRow(join.getInputNodes().get(1));
        }
    }

    private void enableCalcOutputBinaryRow(ExecNode<BatchTableEnvironment, ?> input) {
        if (input instanceof BatchExecCalc) {
            ((BatchExecCalc)input).enableOutputBinaryRow();
        }
    }
}

