/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.util.resource;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.flink.util.StringUtils;

public class AbstractJsonSerializable {
    public static <T> T fromJson(String json, Class c) {
        return AbstractJsonSerializable.fromJson(json, c, false);
    }

    public static <T> T fromJson(String json, Class c, boolean ignoreUnknownProperties) {
        if (StringUtils.isNullOrWhitespaceOnly(json)) {
            return null;
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
            if (ignoreUnknownProperties) {
                objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            } else {
                objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
            }
            return (T)objectMapper.readValue(json, c);
        }
        catch (IOException e2) {
            throw new IllegalArgumentException("error converting from JSON string.", e2);
        }
    }

    public static String toJson(Object value) {
        try {
            return new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(value);
        }
        catch (JsonProcessingException e2) {
            throw new AssertionError((Object)("Writing a valid object as JSON string should not fail: " + e2.getMessage()));
        }
    }

    public <T> T copy() {
        return this.copy(this.getClass());
    }

    public <T> T copy(Class cl) {
        try {
            return AbstractJsonSerializable.fromJson(this.toString(), cl, !this.getClass().equals(cl));
        }
        catch (IllegalArgumentException ex) {
            Throwable e2 = ex.getCause();
            assert (e2 instanceof IOException);
            if (e2 instanceof JsonMappingException && e2.getMessage().contains("can not instantiate") && cl.equals(this.getClass())) {
                throw new IllegalArgumentException(String.format("Error copying to type '%s'.  Explicitly passing a target class with default constructor might help.", cl.getTypeName()), e2);
            }
            throw new AssertionError((Object)("reading a valid JSON string should not fail: " + e2.getMessage()));
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public String toString() {
        return AbstractJsonSerializable.toJson(this);
    }
}

