/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.flink.annotation.Public;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.Value;
import org.apache.flink.util.ReflectionUtil;

@Public
public abstract class MapValue<K extends Value, V extends Value>
implements Value,
Map<K, V> {
    private static final long serialVersionUID = 1L;
    private final Class<K> keyClass = ReflectionUtil.getTemplateType1(this.getClass());
    private final Class<V> valueClass = ReflectionUtil.getTemplateType2(this.getClass());
    private final Map<K, V> map;

    public MapValue() {
        this.map = new HashMap();
    }

    public MapValue(Map<K, V> map2) {
        this.map = new HashMap<K, V>(map2);
    }

    @Override
    public void read(DataInputView in) throws IOException {
        this.map.clear();
        try {
            for (int size = in.readInt(); size > 0; --size) {
                Value key = (Value)this.keyClass.newInstance();
                Value val = (Value)this.valueClass.newInstance();
                key.read(in);
                val.read(in);
                this.map.put(key, val);
            }
        }
        catch (IllegalAccessException | InstantiationException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.map.size());
        for (Map.Entry<K, V> entry : this.map.entrySet()) {
            ((Value)entry.getKey()).write(out);
            ((Value)entry.getValue()).write(out);
        }
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public int hashCode() {
        int prime = 47;
        int result = 1;
        result = 47 * result + this.map.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MapValue other = (MapValue)obj;
        return !(this.map == null ? other.map != null : !this.map.equals(other.map));
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public V get(Object key) {
        return (V)((Value)this.map.get(key));
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public V put(K key, V value) {
        return (V)((Value)this.map.put(key, value));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.map.putAll(m);
    }

    @Override
    public V remove(Object key) {
        return (V)((Value)this.map.remove(key));
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }
}

