/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.File;

public class GlobalConfigUtil {
    private static final String CONFIG_DIRECTORY_FALLBACK_1 = "../conf";
    private static final String CONFIG_DIRECTORY_FALLBACK_2 = "conf";

    public static String getValidConfigurationDirectoryFromEnv() {
        String configDir = GlobalConfigUtil.getConfigurationDirectoryFromEnv();
        if (configDir == null) {
            throw new RuntimeException("The configuration directory was not specified. Please specify the directory containing the configuration file through the 'FLINK_CONF_DIR' environment variable.");
        }
        return configDir;
    }

    public static String getConfigurationDirectoryFromEnv() {
        String location = System.getenv("FLINK_CONF_DIR");
        if (location != null) {
            if (!new File(location).exists()) {
                throw new RuntimeException("The configuration directory '" + location + "', specified in the '" + "FLINK_CONF_DIR" + "' environment variable, does not exist.");
            }
        } else if (new File(GlobalConfigUtil.getFlinkConfFile(CONFIG_DIRECTORY_FALLBACK_1)).exists()) {
            location = CONFIG_DIRECTORY_FALLBACK_1;
        } else if (new File(GlobalConfigUtil.getFlinkConfFile(CONFIG_DIRECTORY_FALLBACK_2)).exists()) {
            location = CONFIG_DIRECTORY_FALLBACK_2;
        }
        return location != null ? new File(location).getAbsolutePath() : null;
    }

    private static String getFlinkConfFile(String path) {
        return path + File.separatorChar + "flink-conf.yaml";
    }
}

