/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import org.apache.flink.util.ExceptionUtils;
import org.slf4j.Logger;

public final class IOUtils {
    private static final int BLOCKSIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyBytes(InputStream in, OutputStream out, int buffSize, boolean close2) throws IOException {
        PrintStream ps = out instanceof PrintStream ? (PrintStream)out : null;
        byte[] buf = new byte[buffSize];
        try {
            int bytesRead = in.read(buf);
            while (bytesRead >= 0) {
                out.write(buf, 0, bytesRead);
                if (ps != null && ps.checkError()) {
                    throw new IOException("Unable to write to output stream.");
                }
                bytesRead = in.read(buf);
            }
        }
        finally {
            if (close2) {
                out.close();
                in.close();
            }
        }
    }

    public static void copyBytes(InputStream in, OutputStream out) throws IOException {
        IOUtils.copyBytes(in, out, 4096, true);
    }

    public static void copyBytes(InputStream in, OutputStream out, boolean close2) throws IOException {
        IOUtils.copyBytes(in, out, 4096, close2);
    }

    public static void readFully(InputStream in, byte[] buf, int off, int len) throws IOException {
        int toRead = len;
        while (toRead > 0) {
            int ret = in.read(buf, off, toRead);
            if (ret < 0) {
                throw new IOException("Premeture EOF from inputStream");
            }
            toRead -= ret;
            off += ret;
        }
    }

    public static void skipFully(InputStream in, long len) throws IOException {
        while (len > 0L) {
            long ret = in.skip(len);
            if (ret < 0L) {
                throw new IOException("Premeture EOF from inputStream");
            }
            len -= ret;
        }
    }

    public static void cleanup(Logger log2, AutoCloseable ... closeables) {
        for (AutoCloseable c : closeables) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (Exception e2) {
                if (log2 == null || !log2.isDebugEnabled()) continue;
                log2.debug("Exception in closing " + c, (Throwable)e2);
            }
        }
    }

    public static void closeStream(Closeable stream) {
        IOUtils.cleanup(null, stream);
    }

    public static void closeSocket(Socket sock) {
        if (sock != null) {
            try {
                sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeAll(Iterable<? extends AutoCloseable> closeables) throws Exception {
        if (null != closeables) {
            Exception collectedExceptions = null;
            for (AutoCloseable autoCloseable : closeables) {
                try {
                    if (null == autoCloseable) continue;
                    autoCloseable.close();
                }
                catch (Exception e2) {
                    collectedExceptions = ExceptionUtils.firstOrSuppressed(e2, collectedExceptions);
                }
            }
            if (null != collectedExceptions) {
                throw collectedExceptions;
            }
        }
    }

    public static void closeAllQuietly(Iterable<? extends AutoCloseable> closeables) {
        if (null != closeables) {
            for (AutoCloseable autoCloseable : closeables) {
                IOUtils.closeQuietly(autoCloseable);
            }
        }
    }

    public static void closeQuietly(AutoCloseable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private IOUtils() {
    }
}

