/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util.checkpointlock;

import javax.annotation.Nonnull;
import org.apache.flink.util.checkpointlock.CheckpointLockHelper;
import org.apache.flink.util.checkpointlock.FairLock;
import org.apache.flink.util.checkpointlock.FairLockHelper;
import org.apache.flink.util.checkpointlock.SynchronizedLockHelper;

public class CheckpointLockDelegate
implements CheckpointLockHelper {
    @Nonnull
    private final CheckpointLockHelper lockHelper;

    public CheckpointLockDelegate(Object lock) {
        this.lockHelper = lock instanceof FairLock ? new FairLockHelper((FairLock)lock) : new SynchronizedLockHelper(lock);
    }

    public final boolean isFair() {
        return this.lockHelper instanceof FairLockHelper;
    }

    @Override
    public final Object getLock() {
        return this.lockHelper.getLock();
    }

    @Override
    public boolean isHeldByCurrentThread() {
        return this.lockHelper.isHeldByCurrentThread();
    }

    @Override
    public void lockAndRun(CheckpointLockHelper.Function1 function) throws Exception {
        this.lockHelper.lockAndRun(function);
    }

    @Override
    public <R> R lockAndRun(CheckpointLockHelper.Function2<R> function) throws Exception {
        return this.lockHelper.lockAndRun(function);
    }

    @Override
    public void lockAndRunQuietly(CheckpointLockHelper.Function3 function) {
        this.lockHelper.lockAndRunQuietly(function);
    }

    @Override
    public <R> R lockAndRunQuietly(CheckpointLockHelper.Function4<R> function) {
        return this.lockHelper.lockAndRunQuietly(function);
    }

    @Override
    public final void await() throws InterruptedException {
        this.lockHelper.await();
    }

    @Override
    public final void await(long timeout) throws InterruptedException {
        this.lockHelper.await(timeout);
    }

    @Override
    public final void await(long timeout, int nanos) throws InterruptedException {
        this.lockHelper.await(timeout, nanos);
    }

    @Override
    public final void signal() {
        this.lockHelper.signal();
    }

    @Override
    public final void signalAll() {
        this.lockHelper.signalAll();
    }
}

