/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util.checkpointlock;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.checkpointlock.CheckpointLockHelper;
import org.apache.flink.util.checkpointlock.FairLock;

class FairLockHelper
implements CheckpointLockHelper {
    @Nonnull
    private final FairLock fairLock;

    public FairLockHelper(FairLock fairLock) {
        Preconditions.checkNotNull(fairLock);
        this.fairLock = fairLock;
    }

    @Override
    public FairLock getLock() {
        return this.fairLock;
    }

    @Override
    public boolean isHeldByCurrentThread() {
        return this.fairLock.getRawLock().isHeldByCurrentThread();
    }

    @Override
    public void lockAndRun(CheckpointLockHelper.Function1 function) throws Exception {
        try {
            this.fairLock.getRawLock().lock();
            function.run();
        }
        finally {
            this.fairLock.getRawLock().unlock();
        }
    }

    @Override
    public <R> R lockAndRun(CheckpointLockHelper.Function2<R> function) throws Exception {
        try {
            this.fairLock.getRawLock().lock();
            R r = function.run();
            return r;
        }
        finally {
            this.fairLock.getRawLock().unlock();
        }
    }

    @Override
    public void lockAndRunQuietly(CheckpointLockHelper.Function3 function) {
        try {
            this.fairLock.getRawLock().lock();
            function.run();
        }
        finally {
            this.fairLock.getRawLock().unlock();
        }
    }

    @Override
    public <R> R lockAndRunQuietly(CheckpointLockHelper.Function4<R> function) {
        try {
            this.fairLock.getRawLock().lock();
            R r = function.run();
            return r;
        }
        finally {
            this.fairLock.getRawLock().unlock();
        }
    }

    @Override
    public void await() throws InterruptedException {
        this.fairLock.await();
    }

    @Override
    public void await(long timeout) throws InterruptedException {
        this.fairLock.await(timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public void await(long timeout, int nanos) throws InterruptedException {
        this.fairLock.awaitNanos(timeout * 1000000L + (long)nanos);
    }

    @Override
    public void signal() {
        this.fairLock.signal();
    }

    @Override
    public void signalAll() {
        this.fairLock.signalAll();
    }
}

