/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util.checkpointlock;

import javax.annotation.Nonnull;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.checkpointlock.CheckpointLockHelper;

class SynchronizedLockHelper
implements CheckpointLockHelper {
    @Nonnull
    private final Object lock;

    public SynchronizedLockHelper(Object lock) {
        Preconditions.checkNotNull(lock);
        this.lock = lock;
    }

    @Override
    public Object getLock() {
        return this.lock;
    }

    @Override
    public boolean isHeldByCurrentThread() {
        return Thread.holdsLock(this.lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockAndRun(CheckpointLockHelper.Function1 function) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            function.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R lockAndRun(CheckpointLockHelper.Function2<R> function) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            return function.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockAndRunQuietly(CheckpointLockHelper.Function3 function) {
        Object object = this.lock;
        synchronized (object) {
            function.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R lockAndRunQuietly(CheckpointLockHelper.Function4<R> function) {
        Object object = this.lock;
        synchronized (object) {
            return function.run();
        }
    }

    @Override
    public void await() throws InterruptedException {
        this.lock.wait();
    }

    @Override
    public void await(long timeout) throws InterruptedException {
        this.lock.wait(timeout);
    }

    @Override
    public void await(long timeout, int nanos) throws InterruptedException {
        this.lock.wait(timeout, nanos);
    }

    @Override
    public void signal() {
        this.lock.notify();
    }

    @Override
    public void signalAll() {
        this.lock.notifyAll();
    }
}

