/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.alibaba.cloud.context.ans;

import java.util.Map;

import com.alibaba.cloud.context.AliCloudServerMode;

/**
 * ANS配置
 *
 * @author xiaolongzuo
 */
public interface AnsConfiguration {

    /**
     * 获取服务端模式
     *
     * @return 服务端模式
     */
    AliCloudServerMode getServerMode();

    /**
     * 获取服务器列表
     *
     * @return 服务器列表
     */
    String getServerList();

    /**
     * 获取服务器端口
     *
     * @return 获取服务器端口
     */
    String getServerPort();

    String getClientDomains();

    float getClientWeight();

    Map<String, Float> getClientWeights();

    String getClientToken();

    Map<String, String> getClientTokens();

    String getClientCluster();

    Map<String, String> getClientMetadata();

    boolean isRegisterEnabled();

    String getClientIp();

    String getClientInterfaceName();

    int getClientPort();

    String getEnv();

    boolean isSecure();

    Map<String, String> getTags();

}
