/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.context.ans;

import com.alibaba.cloud.context.AliCloudConfiguration;
import com.alibaba.cloud.context.AliCloudServerMode;
import com.alibaba.cloud.context.ans.AnsConfiguration;
import com.alibaba.cloud.context.edas.AliCloudEdasSdk;
import com.alibaba.cloud.context.edas.AliCloudEdasSdkFactory;
import com.alibaba.cloud.context.edas.EdasChangeOrderConfiguration;
import com.alibaba.cloud.context.edas.EdasChangeOrderConfigurationFactory;
import com.alibaba.cloud.context.edas.EdasConfiguration;
import com.alibaba.cloud.context.utils.AssertUtils;
import com.aliyuncs.edas.model.v20170801.GetSecureTokenResponse;
import com.aliyuncs.edas.model.v20170801.InsertApplicationResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliCloudAnsInitializer {
    private static final Logger log = LoggerFactory.getLogger(AliCloudAnsInitializer.class);

    private AliCloudAnsInitializer() {
    }

    public static void initialize(AliCloudConfiguration aliCloudConfiguration, EdasConfiguration edasConfiguration, AnsConfiguration ansConfiguration) {
        AliCloudAnsInitializer.initialize(aliCloudConfiguration, edasConfiguration, ansConfiguration, null);
    }

    public static void initialize(AliCloudConfiguration aliCloudConfiguration, EdasConfiguration edasConfiguration, AnsConfiguration ansConfiguration, AliCloudEdasSdk aliCloudEdasSdk) {
        EdasChangeOrderConfiguration edasChangeOrderConfiguration = EdasChangeOrderConfigurationFactory.getEdasChangeOrderConfiguration();
        if (edasChangeOrderConfiguration.isEdasManaged()) {
            log.info("Initialize ans from edas change order.");
            AliCloudAnsInitializer.initializeFromEdasChangeOrder(edasChangeOrderConfiguration);
        } else if (ansConfiguration.getServerMode() == AliCloudServerMode.EDAS || edasConfiguration.isEnabled()) {
            log.info("Initialize ans from pop api.");
            AliCloudAnsInitializer.initializeFromPopApi(aliCloudConfiguration, edasConfiguration, aliCloudEdasSdk);
        } else {
            log.info("Initialize ans from ans configuration.");
            AliCloudAnsInitializer.initializeFromAnsConfiguration(ansConfiguration);
        }
    }

    private static void initializeFromEdasChangeOrder(EdasChangeOrderConfiguration edasChangeOrderConfiguration) {
        System.setProperty("com.alibaba.vipserver.tenant.app", edasChangeOrderConfiguration.getProjectName());
        System.setProperty("com.alibaba.vipserver.tenant.id", edasChangeOrderConfiguration.getTenantId());
        System.setProperty("com.alibaba.vipserver.tenant.ak", edasChangeOrderConfiguration.getDauthAccessKey());
        System.setProperty("com.alibaba.vipserver.tenant.sk", edasChangeOrderConfiguration.getDauthSecretKey());
        System.setProperty("address.server.port", edasChangeOrderConfiguration.getAddressServerPort());
        System.setProperty("address.server.domain", edasChangeOrderConfiguration.getAddressServerDomain());
    }

    private static void initializeFromPopApi(AliCloudConfiguration aliCloudConfiguration, EdasConfiguration edasConfiguration, AliCloudEdasSdk aliCloudEdasSdk) {
        AssertUtils.notNull(aliCloudConfiguration.getAccessKey(), "Access key can't be null.");
        AssertUtils.notNull(aliCloudConfiguration.getSecretKey(), "Secret key can't be null.");
        AssertUtils.notNull(edasConfiguration.getNamespace(), "Namespace can't be null.");
        AssertUtils.isTrue(edasConfiguration.isApplicationNameValid(), "Application name can't be empty.");
        if (aliCloudEdasSdk == null) {
            aliCloudEdasSdk = AliCloudEdasSdkFactory.getDefaultAliCloudEdasSdk(aliCloudConfiguration, edasConfiguration.getRegionId());
        }
        GetSecureTokenResponse.SecureToken secureToken = aliCloudEdasSdk.getSecureToken(edasConfiguration.getNamespace());
        InsertApplicationResponse.ApplicationInfo applicationInfo = aliCloudEdasSdk.getApplicationInfo(edasConfiguration.getApplicationName(), edasConfiguration.getNamespace());
        System.setProperty("com.alibaba.vipserver.tenant.id", secureToken.getTenantId());
        System.setProperty("com.alibaba.vipserver.tenant.ak", secureToken.getAccessKey());
        System.setProperty("com.alibaba.vipserver.tenant.sk", secureToken.getSecretKey());
        System.setProperty("address.server.domain", secureToken.getAddressServerHost());
        System.setProperty("com.alibaba.vipserver.tenant.app", applicationInfo.getAppId());
    }

    private static void initializeFromAnsConfiguration(AnsConfiguration ansConfiguration) {
        System.setProperty("com.alibaba.ans.shaded.com.taobao.vipserver.serverlist", ansConfiguration.getServerList());
        System.setProperty("vipserver.server.port", ansConfiguration.getServerPort());
    }
}

