/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.analyticdb.adbclient;

import java.util.ArrayList;
import java.util.HashMap;

public class ColumnDataType {
    public static final int BOOLEAN = 1;
    public static final int BYTE = 2;
    public static final int SHORT = 3;
    public static final int INT = 4;
    public static final int LONG = 5;
    public static final int DECIMAL = 6;
    public static final int DOUBLE = 7;
    public static final int FLOAT = 8;
    public static final int TIME = 9;
    public static final int DATE = 10;
    public static final int TIMESTAMP = 11;
    public static final int STRING = 13;
    public static final int BLOB = 15;
    public static final int CLOB = 16;
    public static final int JSON = 18;
    public static final int ARRAY = 19;
    public static final int ARRAY_BOOLEAN = 50;
    public static final int ARRAY_BYTE = 51;
    public static final int ARRAY_SHORT = 52;
    public static final int ARRAY_INT = 53;
    public static final int ARRAY_FLOAT = 54;
    public static final int ARRAY_DOUBLE = 55;
    public static final int ARRAY_LONG = 56;
    public static final int MULTI_VALUE = 22;
    public static final int TYPE_COUNT = 57;
    private static final ArrayList<ColumnDataType> TYPES = new ArrayList();
    private static final HashMap<String, ColumnDataType> TYPES_BY_NAME = new HashMap();
    private static final ArrayList<ColumnDataType> TYPES_BY_VALUE_TYPE = new ArrayList();
    protected int type;
    protected String name;
    protected int sqlType;
    protected String jdbc;
    protected int sqlTypePos;

    public static String getNames(int[] dataTypes) {
        ArrayList<String> names = new ArrayList<String>(dataTypes.length);
        for (int dataType : dataTypes) {
            names.add(ColumnDataType.getDataType((int)dataType).name);
        }
        return ((Object)names).toString();
    }

    private static void add(int type, int sqlType, String jdbc, String[] names) {
        for (int i = 0; i < names.length; ++i) {
            ColumnDataType dt = new ColumnDataType();
            dt.type = type;
            dt.sqlType = sqlType;
            dt.jdbc = jdbc;
            dt.name = names[i];
            for (ColumnDataType t2 : TYPES) {
                if (t2.sqlType != dt.sqlType) continue;
                ++dt.sqlTypePos;
            }
            TYPES_BY_NAME.put(dt.name, dt);
            if (TYPES_BY_VALUE_TYPE.get(type) == null) {
                TYPES_BY_VALUE_TYPE.set(type, dt);
            }
            TYPES.add(dt);
        }
    }

    public static ColumnDataType getDataType(int type) {
        if (type < 0 || type >= 57) {
            throw new IllegalArgumentException("type=" + type);
        }
        ColumnDataType dt = TYPES_BY_VALUE_TYPE.get(type);
        return dt;
    }

    public static ColumnDataType getTypeByName(String s) {
        return TYPES_BY_NAME.get(s);
    }

    static {
        for (int i = 0; i < 57; ++i) {
            TYPES_BY_VALUE_TYPE.add(null);
        }
        ColumnDataType.add(13, 12, "String", new String[]{"VARCHAR", "VARCHAR2", "NVARCHAR", "NVARCHAR2", "VARCHAR_CASESENSITIVE", "CHARACTER VARYING", "TID"});
        ColumnDataType.add(13, -1, "String", new String[]{"LONGVARCHAR", "LONGNVARCHAR"});
        ColumnDataType.add(1, 16, "Boolean", new String[]{"BOOLEAN", "BIT", "BOOL"});
        ColumnDataType.add(2, -6, "Byte", new String[]{"TINYINT"});
        ColumnDataType.add(3, 5, "Short", new String[]{"SMALLINT", "YEAR", "INT2"});
        ColumnDataType.add(4, 4, "Int", new String[]{"INTEGER", "INT", "MEDIUMINT", "INT4", "SIGNED"});
        ColumnDataType.add(4, 4, "Int", new String[]{"SERIAL"});
        ColumnDataType.add(5, -5, "Long", new String[]{"BIGINT", "INT8", "LONG"});
        ColumnDataType.add(5, -5, "Long", new String[]{"IDENTITY", "BIGSERIAL"});
        ColumnDataType.add(6, 3, "BigDecimal", new String[]{"DECIMAL", "DEC"});
        ColumnDataType.add(6, 2, "BigDecimal", new String[]{"NUMERIC", "NUMBER"});
        ColumnDataType.add(8, 7, "Float", new String[]{"REAL", "FLOAT4"});
        ColumnDataType.add(7, 8, "Double", new String[]{"DOUBLE", "DOUBLE PRECISION"});
        ColumnDataType.add(7, 6, "Double", new String[]{"FLOAT", "FLOAT8"});
        ColumnDataType.add(9, 92, "Time", new String[]{"TIME"});
        ColumnDataType.add(10, 91, "Date", new String[]{"DATE"});
        ColumnDataType.add(11, 93, "Timestamp", new String[]{"TIMESTAMP", "DATETIME", "SMALLDATETIME"});
        ColumnDataType.add(22, 12, "String", new String[]{"MULTIVALUE"});
        ColumnDataType.add(15, 12, "String", new String[]{"BLOB"});
        ColumnDataType.add(16, 12, "String", new String[]{"CLOB"});
        ColumnDataType.add(18, 12, "String", new String[]{"JSON"});
        ColumnDataType.add(19, 12, "String", new String[]{"ARRAY"});
        ColumnDataType.add(50, 12, "String", new String[]{"ARRAY_BOOLEAN"});
        ColumnDataType.add(51, 12, "String", new String[]{"ARRAY_BYTE"});
        ColumnDataType.add(52, 12, "String", new String[]{"ARRAY_SHORT"});
        ColumnDataType.add(53, 12, "String", new String[]{"ARRAY_INT"});
        ColumnDataType.add(54, 12, "String", new String[]{"ARRAY_FLOAT"});
        ColumnDataType.add(55, 12, "String", new String[]{"ARRAY_DOUBLE"});
        ColumnDataType.add(56, 12, "String", new String[]{"ARRAY_LONG"});
    }
}

