/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.service;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.cloud.dubbo.service.DubboMetadataService;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Router;
import org.apache.dubbo.rpc.cluster.RouterFactory;
import org.apache.dubbo.rpc.cluster.router.AbstractRouter;
import org.springframework.util.CollectionUtils;

public class MetadataServiceRevisionRouterFactory
implements RouterFactory {
    public Router getRouter(URL url) {
        return new AbstractRouter(){

            public <T> List<Invoker<T>> route(List<Invoker<T>> invokers, URL url, Invocation invocation) throws RpcException {
                if (CollectionUtils.isEmpty(invokers)) {
                    return invokers;
                }
                if (!DubboMetadataService.class.getName().equalsIgnoreCase(url.getServiceInterface())) {
                    return invokers;
                }
                String revision = invocation.getAttachment("sca_revision");
                if (StringUtils.isEmpty((CharSequence)revision)) {
                    return invokers;
                }
                ArrayList<Invoker<T>> list = new ArrayList<Invoker<T>>(invokers.size());
                for (Invoker<T> invoker : invokers) {
                    if (!StringUtils.equals((CharSequence)revision, (CharSequence)invoker.getUrl().getParameter("sca_revision"))) continue;
                    list.add(invoker);
                }
                return list;
            }
        };
    }
}

