/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.actuate.endpoint;

import com.alibaba.cloud.dubbo.registry.DubboCloudRegistry;
import com.alibaba.cloud.dubbo.registry.SpringCloudRegistryFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dubbo.common.Node;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.integration.RegistryDirectory;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

@Endpoint(id="dubboRegistryDirectory")
public class DubboDiscoveryEndpoint {
    @ReadOperation(produces={"application/json"})
    public Object get() {
        DubboCloudRegistry registry = SpringCloudRegistryFactory.getRegistries().stream().filter(o -> o instanceof DubboCloudRegistry).findFirst().orElse(null);
        if (registry == null) {
            return Collections.emptyMap();
        }
        Map subscribeMap = registry.getSubscribed();
        HashMap result = new HashMap();
        subscribeMap.forEach((url, listeners) -> {
            String side = url.getParameter("side");
            if (!"consumer".equals(side)) {
                return;
            }
            List pairs = result.computeIfAbsent(url.getServiceKey(), o -> new ArrayList());
            HashMap<String, Object> pair = new HashMap<String, Object>();
            ArrayList invokerServices = new ArrayList();
            for (NotifyListener listener : listeners) {
                RegistryDirectory directory;
                List invokers;
                if (!(listener instanceof RegistryDirectory) || (invokers = (directory = (RegistryDirectory)listener).getAllInvokers()) == null) continue;
                invokerServices.addAll(invokers.stream().map(Node::getUrl).map(URL::toServiceString).collect(Collectors.toList()));
            }
            pair.put("invokers", invokerServices);
            pair.put("subscribeUrl", url.toMap());
            pairs.add(pair);
        });
        return result;
    }
}

