/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.metadata;

import com.alibaba.cloud.dubbo.metadata.repository.DubboServiceMetadataRepository;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;

public final class RevisionResolver {
    public static final String SCA_REVSION_KEY = "sca_revision";
    private static final String EMPTY_REVISION = "0";
    private static final Logger logger = LoggerFactory.getLogger(RevisionResolver.class);
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static MessageDigest mdInst;

    private RevisionResolver() {
    }

    public static String getEmptyRevision() {
        return EMPTY_REVISION;
    }

    public static String calRevision(String metadata) {
        mdInst.update(metadata.getBytes(StandardCharsets.UTF_8));
        byte[] md5 = mdInst.digest();
        int j = md5.length;
        char[] str = new char[j * 2];
        int k = 0;
        for (byte byte0 : md5) {
            str[k++] = hexDigits[byte0 >>> 4 & 0xF];
            str[k++] = hexDigits[byte0 & 0xF];
        }
        return new String(str);
    }

    public static String getRevision(ServiceInstance instance) {
        Map metadata = instance.getMetadata();
        String revision = (String)metadata.get(DubboServiceMetadataRepository.EXPORTED_SERVICES_REVISION_PROPERTY_NAME);
        if (revision == null) {
            revision = RevisionResolver.getEmptyRevision();
        }
        return revision;
    }

    static {
        try {
            mdInst = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Failed to calculate metadata revision", (Throwable)e);
        }
    }
}

