/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.service.parameter;

import com.alibaba.cloud.dubbo.http.HttpServerRequest;
import com.alibaba.cloud.dubbo.metadata.MethodParameterMetadata;
import com.alibaba.cloud.dubbo.metadata.RestMethodMetadata;
import com.alibaba.cloud.dubbo.service.parameter.AbstractDubboGenericServiceParameterResolver;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;

public abstract class AbstractNamedValueServiceParameterResolver
extends AbstractDubboGenericServiceParameterResolver {
    protected abstract MultiValueMap<String, String> getNameAndValuesMap(HttpServerRequest var1);

    @Override
    public Object resolve(RestMethodMetadata restMethodMetadata, MethodParameterMetadata methodParameterMetadata, HttpServerRequest request) {
        Collection<String> names = this.getNames(restMethodMetadata, methodParameterMetadata);
        if (ObjectUtils.isEmpty(names)) {
            return null;
        }
        MultiValueMap<String, String> nameAndValues = this.getNameAndValuesMap(request);
        String targetName = null;
        for (String name : names) {
            if (!nameAndValues.containsKey((Object)name)) continue;
            targetName = name;
            break;
        }
        if (targetName == null) {
            return null;
        }
        Class<?> parameterType = this.resolveClass(methodParameterMetadata.getType());
        Object paramValue = null;
        paramValue = parameterType.isArray() ? nameAndValues.get((Object)targetName) : nameAndValues.getFirst((Object)targetName);
        return this.resolveValue(paramValue, parameterType);
    }

    @Override
    public Object resolve(RestMethodMetadata restMethodMetadata, MethodParameterMetadata methodParameterMetadata, RestMethodMetadata clientRestMethodMetadata, Object[] arguments) {
        Collection<String> names = this.getNames(restMethodMetadata, methodParameterMetadata);
        if (ObjectUtils.isEmpty(names)) {
            return null;
        }
        Integer index = null;
        Map<Integer, Collection<String>> clientIndexToName = clientRestMethodMetadata.getIndexToName();
        for (Map.Entry<Integer, Collection<String>> entry : clientIndexToName.entrySet()) {
            Collection<String> clientParamNames = entry.getValue();
            if (!CollectionUtils.containsAny(names, clientParamNames)) continue;
            index = entry.getKey();
            break;
        }
        return index > -1 ? arguments[index] : null;
    }

    protected Collection<String> getNames(RestMethodMetadata restMethodMetadata, MethodParameterMetadata methodParameterMetadata) {
        int index;
        Map<Integer, Collection<String>> indexToName = restMethodMetadata.getIndexToName();
        Collection<String> paramNames = indexToName.get(index = methodParameterMetadata.getIndex());
        return paramNames == null ? Collections.emptyList() : paramNames;
    }
}

