/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cola.statemachine.builder;

import com.alibaba.cola.statemachine.State;
import com.alibaba.cola.statemachine.StateMachine;
import com.alibaba.cola.statemachine.StateMachineFactory;
import com.alibaba.cola.statemachine.builder.ExternalTransitionBuilder;
import com.alibaba.cola.statemachine.builder.ExternalTransitionsBuilder;
import com.alibaba.cola.statemachine.builder.InternalTransitionBuilder;
import com.alibaba.cola.statemachine.builder.StateMachineBuilder;
import com.alibaba.cola.statemachine.builder.TransitionBuilderImpl;
import com.alibaba.cola.statemachine.builder.TransitionsBuilderImpl;
import com.alibaba.cola.statemachine.impl.StateMachineImpl;
import com.alibaba.cola.statemachine.impl.TransitionType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StateMachineBuilderImpl<S, E, C>
implements StateMachineBuilder<S, E, C> {
    private final Map<S, State<S, E, C>> stateMap = new ConcurrentHashMap<S, State<S, E, C>>();
    private final StateMachineImpl<S, E, C> stateMachine = new StateMachineImpl<S, E, C>(this.stateMap);

    @Override
    public ExternalTransitionBuilder<S, E, C> externalTransition() {
        return new TransitionBuilderImpl<S, E, C>(this.stateMap, TransitionType.EXTERNAL);
    }

    @Override
    public ExternalTransitionsBuilder<S, E, C> externalTransitions() {
        return new TransitionsBuilderImpl<S, E, C>(this.stateMap, TransitionType.EXTERNAL);
    }

    @Override
    public InternalTransitionBuilder<S, E, C> internalTransition() {
        return new TransitionBuilderImpl<S, E, C>(this.stateMap, TransitionType.INTERNAL);
    }

    @Override
    public StateMachine<S, E, C> build(String machineId) {
        this.stateMachine.setMachineId(machineId);
        this.stateMachine.setReady(true);
        StateMachineFactory.register(this.stateMachine);
        return this.stateMachine;
    }
}

