/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.socket.nio;

import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.Channel;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.ChannelFuture;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.ChannelPipeline;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.ChannelSink;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.Channels;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.socket.nio.AbstractNioSelector;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.socket.nio.Boss;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.socket.nio.NioAcceptedSocketChannel;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.socket.nio.NioServerSocketChannel;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.socket.nio.NioWorker;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.util.ThreadNameDeterminer;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.util.ThreadRenamingRunnable;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Executor;

public final class NioServerBoss
extends AbstractNioSelector
implements Boss {
    NioServerBoss(Executor bossExecutor) {
        super(bossExecutor);
    }

    NioServerBoss(Executor bossExecutor, ThreadNameDeterminer determiner) {
        super(bossExecutor, determiner);
    }

    void bind(NioServerSocketChannel channel, ChannelFuture future, SocketAddress localAddress) {
        this.registerTask(new RegisterTask(channel, future, localAddress));
    }

    protected void close(SelectionKey k) {
        NioServerSocketChannel ch = (NioServerSocketChannel)k.attachment();
        this.close(ch, Channels.succeededFuture(ch));
    }

    void close(NioServerSocketChannel channel, ChannelFuture future) {
        boolean bound = channel.isBound();
        try {
            channel.socket.close();
            this.increaseCancelledKeys();
            if (channel.setClosed()) {
                future.setSuccess();
                if (bound) {
                    Channels.fireChannelUnbound(channel);
                }
                Channels.fireChannelClosed(channel);
            } else {
                future.setSuccess();
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    protected void process(Selector selector) {
        Set<SelectionKey> selectedKeys = selector.selectedKeys();
        if (selectedKeys.isEmpty()) {
            return;
        }
        Iterator<SelectionKey> i = selectedKeys.iterator();
        while (i.hasNext()) {
            SelectionKey k = i.next();
            i.remove();
            NioServerSocketChannel channel = (NioServerSocketChannel)k.attachment();
            try {
                SocketChannel acceptedSocket;
                while ((acceptedSocket = channel.socket.accept()) != null) {
                    NioServerBoss.registerAcceptedChannel(channel, acceptedSocket, this.thread);
                }
            }
            catch (CancelledKeyException e) {
                k.cancel();
                channel.close();
            }
            catch (SocketTimeoutException e) {
            }
            catch (ClosedChannelException e) {
            }
            catch (Throwable t) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Failed to accept a connection.", t);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {}
            }
        }
    }

    private static void registerAcceptedChannel(NioServerSocketChannel parent, SocketChannel acceptedSocket, Thread currentThread) {
        block5: {
            try {
                ChannelSink sink = parent.getPipeline().getSink();
                ChannelPipeline pipeline = parent.getConfig().getPipelineFactory().getPipeline();
                NioWorker worker = parent.workerPool.nextWorker();
                worker.register(new NioAcceptedSocketChannel(parent.getFactory(), pipeline, parent, sink, acceptedSocket, worker, currentThread), null);
            }
            catch (Exception e) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Failed to initialize an accepted socket.", e);
                }
                try {
                    acceptedSocket.close();
                }
                catch (IOException e2) {
                    if (!logger.isWarnEnabled()) break block5;
                    logger.warn("Failed to close a partially accepted socket.", e2);
                }
            }
        }
    }

    protected int select(Selector selector) throws IOException {
        return selector.select();
    }

    protected ThreadRenamingRunnable newThreadRenamingRunnable(int id, ThreadNameDeterminer determiner) {
        return new ThreadRenamingRunnable(this, "New I/O server boss #" + id, determiner);
    }

    protected Runnable createRegisterTask(Channel channel, ChannelFuture future) {
        return new RegisterTask((NioServerSocketChannel)channel, future, null);
    }

    private final class RegisterTask
    implements Runnable {
        private final NioServerSocketChannel channel;
        private final ChannelFuture future;
        private final SocketAddress localAddress;

        public RegisterTask(NioServerSocketChannel channel, ChannelFuture future, SocketAddress localAddress) {
            this.channel = channel;
            this.future = future;
            this.localAddress = localAddress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean bound = false;
            boolean registered = false;
            try {
                try {
                    this.channel.socket.socket().bind(this.localAddress, this.channel.getConfig().getBacklog());
                    bound = true;
                    this.future.setSuccess();
                    Channels.fireChannelBound(this.channel, (SocketAddress)this.channel.getLocalAddress());
                    this.channel.socket.register(NioServerBoss.this.selector, 16, this.channel);
                    registered = true;
                }
                catch (Throwable t) {
                    this.future.setFailure(t);
                    Channels.fireExceptionCaught(this.channel, t);
                    Object var5_4 = null;
                    if (!registered && bound) {
                        NioServerBoss.this.close(this.channel, this.future);
                    }
                }
                Object var5_3 = null;
                if (!registered && bound) {
                    NioServerBoss.this.close(this.channel, this.future);
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (!registered && bound) {
                    NioServerBoss.this.close(this.channel, this.future);
                }
                throw throwable;
            }
        }
    }
}

