/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.handler.codec.compression;

import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.buffer.ChannelBuffer;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.buffer.ChannelBuffers;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.Channel;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.ChannelEvent;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.ChannelFuture;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.ChannelFutureListener;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.ChannelHandlerContext;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.ChannelStateEvent;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.Channels;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.LifeCycleAwareChannelHandler;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.handler.codec.compression.ZlibWrapper;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.handler.codec.oneone.OneToOneStrictEncoder;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

public class JdkZlibEncoder
extends OneToOneStrictEncoder
implements LifeCycleAwareChannelHandler {
    private final ZlibWrapper wrapper;
    private final Deflater deflater;
    private final AtomicBoolean finished = new AtomicBoolean();
    private volatile ChannelHandlerContext ctx;
    private byte[] out;
    private final CRC32 crc;
    private static final byte[] gzipHeader = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0};
    private boolean writeHeader = true;

    public JdkZlibEncoder() {
        this(6);
    }

    public JdkZlibEncoder(int compressionLevel) {
        this(ZlibWrapper.ZLIB, compressionLevel);
    }

    public JdkZlibEncoder(ZlibWrapper wrapper) {
        this(wrapper, 6);
    }

    public JdkZlibEncoder(ZlibWrapper wrapper, int compressionLevel) {
        if (compressionLevel < 0 || compressionLevel > 9) {
            throw new IllegalArgumentException("compressionLevel: " + compressionLevel + " (expected: 0-9)");
        }
        if (wrapper == null) {
            throw new NullPointerException("wrapper");
        }
        if (wrapper == ZlibWrapper.ZLIB_OR_NONE) {
            throw new IllegalArgumentException("wrapper '" + (Object)((Object)ZlibWrapper.ZLIB_OR_NONE) + "' is not " + "allowed for compression.");
        }
        this.wrapper = wrapper;
        this.deflater = new Deflater(compressionLevel, wrapper != ZlibWrapper.ZLIB);
        this.crc = wrapper == ZlibWrapper.GZIP ? new CRC32() : null;
    }

    public JdkZlibEncoder(byte[] dictionary) {
        this(6, dictionary);
    }

    public JdkZlibEncoder(int compressionLevel, byte[] dictionary) {
        if (compressionLevel < 0 || compressionLevel > 9) {
            throw new IllegalArgumentException("compressionLevel: " + compressionLevel + " (expected: 0-9)");
        }
        if (dictionary == null) {
            throw new NullPointerException("dictionary");
        }
        this.wrapper = ZlibWrapper.ZLIB;
        this.crc = null;
        this.deflater = new Deflater(compressionLevel);
        this.deflater.setDictionary(dictionary);
    }

    public ChannelFuture close() {
        ChannelHandlerContext ctx = this.ctx;
        if (ctx == null) {
            throw new IllegalStateException("not added to a pipeline");
        }
        return this.finishEncode(ctx, null);
    }

    private boolean isGzip() {
        return this.wrapper == ZlibWrapper.GZIP;
    }

    public boolean isClosed() {
        return this.finished.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (!(msg instanceof ChannelBuffer) || this.finished.get()) {
            return msg;
        }
        ChannelBuffer uncompressed = (ChannelBuffer)msg;
        int uncompressedLen = uncompressed.readableBytes();
        if (uncompressedLen == 0) {
            return uncompressed;
        }
        byte[] in = new byte[uncompressedLen];
        uncompressed.readBytes(in);
        int sizeEstimate = this.estimateCompressedSize(uncompressedLen);
        ChannelBuffer compressed = ChannelBuffers.dynamicBuffer(sizeEstimate, channel.getConfig().getBufferFactory());
        Deflater deflater = this.deflater;
        synchronized (deflater) {
            if (this.isGzip()) {
                this.crc.update(in);
                if (this.writeHeader) {
                    compressed.writeBytes(gzipHeader);
                    this.writeHeader = false;
                }
            }
            this.deflater.setInput(in);
            while (!this.deflater.needsInput()) {
                this.deflate(compressed);
            }
        }
        return compressed;
    }

    private int estimateCompressedSize(int originalSize) {
        int sizeEstimate = (int)Math.ceil((double)originalSize * 1.001) + 12;
        if (this.writeHeader) {
            switch (this.wrapper) {
                case GZIP: {
                    sizeEstimate += gzipHeader.length;
                    break;
                }
                case ZLIB: {
                    sizeEstimate += 2;
                }
            }
        }
        return sizeEstimate;
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
        if (evt instanceof ChannelStateEvent) {
            ChannelStateEvent e = (ChannelStateEvent)evt;
            switch (e.getState()) {
                case OPEN: 
                case CONNECTED: 
                case BOUND: {
                    if (!Boolean.FALSE.equals(e.getValue()) && e.getValue() != null) break;
                    this.finishEncode(ctx, evt);
                    return;
                }
            }
        }
        super.handleDownstream(ctx, evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelFuture finishEncode(final ChannelHandlerContext ctx, final ChannelEvent evt) {
        ChannelFuture future = Channels.succeededFuture(ctx.getChannel());
        if (!this.finished.compareAndSet(false, true)) {
            if (evt != null) {
                ctx.sendDownstream(evt);
            }
            return future;
        }
        ChannelBuffer footer = ChannelBuffers.dynamicBuffer(ctx.getChannel().getConfig().getBufferFactory());
        boolean gzip = this.isGzip();
        Deflater deflater = this.deflater;
        synchronized (deflater) {
            if (gzip && this.writeHeader) {
                this.writeHeader = false;
                footer.writeBytes(gzipHeader);
            }
            this.deflater.finish();
            while (!this.deflater.finished()) {
                this.deflate(footer);
            }
            if (gzip) {
                int crcValue = (int)this.crc.getValue();
                int uncBytes = this.deflater.getTotalIn();
                footer.writeByte(crcValue);
                footer.writeByte(crcValue >>> 8);
                footer.writeByte(crcValue >>> 16);
                footer.writeByte(crcValue >>> 24);
                footer.writeByte(uncBytes);
                footer.writeByte(uncBytes >>> 8);
                footer.writeByte(uncBytes >>> 16);
                footer.writeByte(uncBytes >>> 24);
            }
            this.deflater.end();
        }
        if (footer.readable()) {
            future = Channels.future(ctx.getChannel());
            Channels.write(ctx, future, footer);
        }
        if (evt != null) {
            future.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    ctx.sendDownstream(evt);
                }
            });
        }
        return future;
    }

    private void deflate(ChannelBuffer out) {
        if (out.hasArray()) {
            int numBytes;
            do {
                int writerIndex = out.writerIndex();
                numBytes = this.deflater.deflate(out.array(), out.arrayOffset() + writerIndex, out.writableBytes(), 2);
                out.writerIndex(writerIndex + numBytes);
            } while (numBytes > 0);
        } else {
            int numBytes;
            byte[] tmpOut = this.out;
            if (tmpOut == null) {
                tmpOut = this.out = new byte[8192];
            }
            do {
                numBytes = this.deflater.deflate(tmpOut, 0, tmpOut.length, 2);
                out.writeBytes(tmpOut, 0, numBytes);
            } while (numBytes > 0);
        }
    }

    public void beforeAdd(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
    }

    public void afterAdd(ChannelHandlerContext ctx) throws Exception {
    }

    public void beforeRemove(ChannelHandlerContext ctx) throws Exception {
    }

    public void afterRemove(ChannelHandlerContext ctx) throws Exception {
    }
}

