/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.handler.codec.http;

import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.buffer.ChannelBuffer;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.buffer.ChannelBuffers;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.handler.codec.http.DefaultHttpHeaders;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.handler.codec.http.HttpCodecUtil;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.handler.codec.http.HttpHeaders;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.handler.codec.http.HttpMessage;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.handler.codec.http.HttpVersion;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.util.internal.StringUtil;
import java.util.Map;

public class DefaultHttpMessage
implements HttpMessage {
    private final HttpHeaders headers = new DefaultHttpHeaders(true);
    private HttpVersion version;
    private ChannelBuffer content = ChannelBuffers.EMPTY_BUFFER;
    private boolean chunked;

    protected DefaultHttpMessage(HttpVersion version) {
        this.setProtocolVersion(version);
    }

    public HttpHeaders headers() {
        return this.headers;
    }

    public boolean isChunked() {
        if (this.chunked) {
            return true;
        }
        return HttpCodecUtil.isTransferEncodingChunked(this);
    }

    public void setChunked(boolean chunked) {
        this.chunked = chunked;
        if (chunked) {
            this.setContent(ChannelBuffers.EMPTY_BUFFER);
        }
    }

    public void setContent(ChannelBuffer content) {
        if (content == null) {
            content = ChannelBuffers.EMPTY_BUFFER;
        }
        if (content.readable() && this.isChunked()) {
            throw new IllegalArgumentException("non-empty content disallowed if this.chunked == true");
        }
        this.content = content;
    }

    public HttpVersion getProtocolVersion() {
        return this.version;
    }

    public void setProtocolVersion(HttpVersion version) {
        if (version == null) {
            throw new NullPointerException("version");
        }
        this.version = version;
    }

    public ChannelBuffer getContent() {
        return this.content;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append("(version: ");
        buf.append(this.getProtocolVersion().getText());
        buf.append(", keepAlive: ");
        buf.append(HttpHeaders.isKeepAlive(this));
        buf.append(", chunked: ");
        buf.append(this.isChunked());
        buf.append(')');
        buf.append(StringUtil.NEWLINE);
        this.appendHeaders(buf);
        buf.setLength(buf.length() - StringUtil.NEWLINE.length());
        return buf.toString();
    }

    void appendHeaders(StringBuilder buf) {
        for (Map.Entry e : this.headers()) {
            buf.append((String)e.getKey());
            buf.append(": ");
            buf.append((String)e.getValue());
            buf.append(StringUtil.NEWLINE);
        }
    }
}

