/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.handler.codec.http;

import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.buffer.ChannelBuffer;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.buffer.ChannelBuffers;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.ChannelHandlerContext;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.ChannelStateEvent;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.Channels;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.LifeCycleAwareChannelHandler;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.MessageEvent;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.SimpleChannelHandler;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.handler.codec.embedder.EncoderEmbedder;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.handler.codec.http.HttpChunk;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.handler.codec.http.HttpMessage;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.handler.codec.http.HttpResponse;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpContentEncoder
extends SimpleChannelHandler
implements LifeCycleAwareChannelHandler {
    private final Queue<String> acceptEncodingQueue = new ConcurrentLinkedQueue<String>();
    private volatile EncoderEmbedder<ChannelBuffer> encoder;
    private volatile boolean offerred;

    protected HttpContentEncoder() {
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object msg = e.getMessage();
        if (!(msg instanceof HttpMessage)) {
            ctx.sendUpstream(e);
            return;
        }
        HttpMessage m = (HttpMessage)msg;
        String acceptedEncoding = m.headers().get("Accept-Encoding");
        if (acceptedEncoding == null) {
            acceptedEncoding = "identity";
        }
        boolean offered = this.acceptEncodingQueue.offer(acceptedEncoding);
        assert (offered);
        ctx.sendUpstream(e);
    }

    @Override
    public void writeRequested(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object msg = e.getMessage();
        if (msg instanceof HttpResponse && ((HttpResponse)msg).getStatus().getCode() == 100) {
            ctx.sendDownstream(e);
        } else if (msg instanceof HttpMessage) {
            HttpMessage m = (HttpMessage)msg;
            this.finishEncode();
            String acceptEncoding = this.acceptEncodingQueue.poll();
            if (acceptEncoding == null) {
                throw new IllegalStateException("cannot send more responses than requests");
            }
            String contentEncoding = m.headers().get("Content-Encoding");
            if (contentEncoding != null && !"identity".equalsIgnoreCase(contentEncoding)) {
                ctx.sendDownstream(e);
            } else {
                boolean hasContent;
                boolean bl = hasContent = m.isChunked() || m.getContent().readable();
                if (hasContent && (this.encoder = this.newContentEncoder(m, acceptEncoding)) != null) {
                    m.headers().set("Content-Encoding", this.getTargetContentEncoding(acceptEncoding));
                    if (m.isChunked()) {
                        m.headers().remove("Content-Length");
                    } else {
                        ChannelBuffer content = m.getContent();
                        content = ChannelBuffers.wrappedBuffer(this.encode(content), this.finishEncode());
                        m.setContent(content);
                        if (m.headers().contains("Content-Length")) {
                            m.headers().set("Content-Length", Integer.toString(content.readableBytes()));
                        }
                    }
                }
                ctx.sendDownstream(e);
            }
        } else if (msg instanceof HttpChunk) {
            HttpChunk c = (HttpChunk)msg;
            ChannelBuffer content = c.getContent();
            if (this.encoder != null) {
                if (!c.isLast()) {
                    if ((content = this.encode(content)).readable()) {
                        c.setContent(content);
                        ctx.sendDownstream(e);
                    }
                } else {
                    ChannelBuffer lastProduct = this.finishEncode();
                    if (lastProduct.readable()) {
                        Channels.write(ctx, Channels.succeededFuture(e.getChannel()), new DefaultHttpChunk(lastProduct), e.getRemoteAddress());
                    }
                    ctx.sendDownstream(e);
                }
            } else {
                ctx.sendDownstream(e);
            }
        } else {
            ctx.sendDownstream(e);
        }
    }

    @Override
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.finishEncode();
        super.channelClosed(ctx, e);
    }

    protected abstract EncoderEmbedder<ChannelBuffer> newContentEncoder(HttpMessage var1, String var2) throws Exception;

    protected abstract String getTargetContentEncoding(String var1) throws Exception;

    private ChannelBuffer encode(ChannelBuffer buf) {
        this.offerred = true;
        this.encoder.offer(buf);
        return ChannelBuffers.wrappedBuffer(this.encoder.pollAll(new ChannelBuffer[this.encoder.size()]));
    }

    private ChannelBuffer finishEncode() {
        if (this.encoder == null) {
            this.offerred = false;
            return ChannelBuffers.EMPTY_BUFFER;
        }
        if (!this.offerred) {
            this.offerred = false;
            this.encoder.offer(ChannelBuffers.EMPTY_BUFFER);
        }
        ChannelBuffer result = this.encoder.finish() ? ChannelBuffers.wrappedBuffer(this.encoder.pollAll(new ChannelBuffer[this.encoder.size()])) : ChannelBuffers.EMPTY_BUFFER;
        this.encoder = null;
        return result;
    }

    @Override
    public void beforeAdd(ChannelHandlerContext ctx) throws Exception {
    }

    @Override
    public void afterAdd(ChannelHandlerContext ctx) throws Exception {
    }

    @Override
    public void beforeRemove(ChannelHandlerContext ctx) throws Exception {
    }

    @Override
    public void afterRemove(ChannelHandlerContext ctx) throws Exception {
        this.finishEncode();
    }
}

