/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.sentinel;

import com.alibaba.csp.ahas.sentinel.AhasSentinelConstants;
import com.alibaba.csp.ahas.sentinel.SimpleDecryptor;
import com.alibaba.csp.ahas.sentinel.datasource.parser.ParamFlowRuleParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.cluster.ClusterAssignStateParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.cluster.ClusterClientAssignConfigParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.cluster.ClusterClientCommonConfigParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.cluster.ClusterServerFlowConfigParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.cluster.ClusterServerTransportConfigParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.gateway.GatewayApiDefinitionParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.gateway.GatewayFlowRuleParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.setting.SentinelAdapterSettingParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.setting.SentinelGeneralSettingParser;
import com.alibaba.csp.ahas.shaded.com.alibaba.csp.sentinel.datasource.acm.DecryptAcmWhiteDataSource;
import com.alibaba.csp.ahas.shaded.com.alibaba.csp.sentinel.datasource.acm.SentinelAcmConstants;
import com.alibaba.csp.ahas.shaded.com.alibaba.csp.sentinel.datasource.acm.parser.DegradeRuleConfigParser;
import com.alibaba.csp.ahas.shaded.com.alibaba.csp.sentinel.datasource.acm.parser.FlowRuleConfigParser;
import com.alibaba.csp.ahas.shaded.com.alibaba.csp.sentinel.datasource.acm.parser.SystemRuleConfigParser;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.api.client.ClientInfoService;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.exception.DiamondException;
import com.alibaba.csp.sentinel.adapter.gateway.common.api.ApiDefinition;
import com.alibaba.csp.sentinel.adapter.gateway.common.api.GatewayApiDefinitionManager;
import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayFlowRule;
import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayRuleManager;
import com.alibaba.csp.sentinel.cluster.ClusterStateManager;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientAssignConfig;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientConfig;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientConfigManager;
import com.alibaba.csp.sentinel.cluster.flow.rule.ClusterFlowRuleManager;
import com.alibaba.csp.sentinel.cluster.server.config.ClusterServerConfigManager;
import com.alibaba.csp.sentinel.cluster.server.config.ServerFlowConfig;
import com.alibaba.csp.sentinel.cluster.server.config.ServerTransportConfig;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.setting.adapter.AdapterSettingManager;
import com.alibaba.csp.sentinel.setting.adapter.SentinelAdapterSettingEntity;
import com.alibaba.csp.sentinel.setting.general.GeneralSettingManager;
import com.alibaba.csp.sentinel.setting.general.SentinelGeneralSettingEntity;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRuleManager;
import com.alibaba.csp.sentinel.slots.system.SystemRule;
import com.alibaba.csp.sentinel.slots.system.SystemRuleManager;
import com.alibaba.csp.sentinel.util.AppNameUtil;
import com.alibaba.csp.sentinel.util.function.Function;
import java.util.Collections;
import java.util.List;
import java.util.Set;

class SentinelAcmDataSourceService {
    private final ClientInfoService clientInfoService;
    private final SimpleDecryptor decryptor;

    public SentinelAcmDataSourceService(ClientInfoService clientInfoService) {
        this.clientInfoService = clientInfoService;
        this.decryptor = new SimpleDecryptor();
    }

    public void initAcmDataSource() throws DiamondException {
        String currentEndPoint = this.clientInfoService.getAcmEndpoint();
        String namespace = this.clientInfoService.getNamespace();
        RecordLog.info("[SentinelAcmDataSourceService] ACM endpoint: " + currentEndPoint, new Object[0]);
        System.setProperty("ahas.address.server.domain", currentEndPoint);
        String userId = this.clientInfoService.getUserId();
        String consoleTenantId = this.clientInfoService.getTid();
        String appName = AppNameUtil.getAppName();
        this.initSettingDs(userId, namespace, consoleTenantId, appName);
        this.initClientRuleDs(userId, namespace, consoleTenantId, appName);
        this.initClusterRuleDsSupplier(userId, namespace, consoleTenantId);
        this.initSentinelClusterDs(userId, namespace, consoleTenantId, appName);
        if (this.isGatewayAppType()) {
            this.initApiGatewayDs(userId, namespace, consoleTenantId, appName);
        }
    }

    private void initClientRuleDs(String userId, String namespace, String consoleTenantId, String appName) throws DiamondException {
        String flowDataId = SentinelAcmConstants.formFlowRuleDataId(userId, namespace, appName);
        FlowRuleManager.register2Property(new DecryptAcmWhiteDataSource<List<FlowRule>>(consoleTenantId, flowDataId, "ahas-sentinel", new FlowRuleConfigParser(), this.decryptor).getProperty());
        String degradeDataId = SentinelAcmConstants.formDegradeRuleDataId(userId, namespace, appName);
        DegradeRuleManager.register2Property(new DecryptAcmWhiteDataSource<List<DegradeRule>>(consoleTenantId, degradeDataId, "ahas-sentinel", new DegradeRuleConfigParser(), this.decryptor).getProperty());
        String systemDataId = SentinelAcmConstants.formSystemRuleDataId(userId, namespace, appName);
        SystemRuleManager.register2Property(new DecryptAcmWhiteDataSource<List<SystemRule>>(consoleTenantId, systemDataId, "ahas-sentinel", new SystemRuleConfigParser(), this.decryptor).getProperty());
        String paramFlowDataId = SentinelAcmConstants.formParamFlowRuleDataId(userId, namespace, appName);
        ParamFlowRuleManager.register2Property(new DecryptAcmWhiteDataSource<List<ParamFlowRule>>(consoleTenantId, paramFlowDataId, "ahas-sentinel", new ParamFlowRuleParser(), this.decryptor).getProperty());
        String log = String.format("acm, flowDataId: %s, degradeDataId: %s, systemDataId: %s, group: %s, tid: %s", flowDataId, degradeDataId, systemDataId, "ahas-sentinel", consoleTenantId);
        RecordLog.info(log, new Object[0]);
    }

    private void initClusterRuleDsSupplier(final String userId, final String acmNamespace, final String consoleTenantId) {
        ClusterFlowRuleManager.setPropertySupplier(new Function<String, SentinelProperty<List<FlowRule>>>(){

            @Override
            public SentinelProperty<List<FlowRule>> apply(String app) {
                String dataId = SentinelAcmConstants.formFlowRuleDataId(userId, acmNamespace, app);
                try {
                    return new DecryptAcmWhiteDataSource<List<FlowRule>>(consoleTenantId, dataId, "ahas-sentinel", new FlowRuleConfigParser(), SentinelAcmDataSourceService.this.decryptor).getProperty();
                }
                catch (Exception ex) {
                    RecordLog.warn("[SentinelAcmDataSourceService] Error when initializing cluster flow rule data source", ex);
                    throw new IllegalStateException(ex);
                }
            }
        });
    }

    private void initSentinelClusterDs(String userId, String acmNamespace, String consoleTenantId, String appName) throws DiamondException {
        String clusterMapDataId = SentinelAcmConstants.formClusterAssignMapDataId(userId, acmNamespace, appName);
        DecryptAcmWhiteDataSource<ServerTransportConfig> serverTransportDs = new DecryptAcmWhiteDataSource<ServerTransportConfig>(consoleTenantId, clusterMapDataId, "ahas-sentinel", new ClusterServerTransportConfigParser(), this.decryptor);
        ClusterServerConfigManager.registerServerTransportProperty(serverTransportDs.getProperty());
        DecryptAcmWhiteDataSource<ServerFlowConfig> serverFlowDs = new DecryptAcmWhiteDataSource<ServerFlowConfig>(consoleTenantId, clusterMapDataId, "ahas-sentinel", new ClusterServerFlowConfigParser(), this.decryptor);
        ClusterServerConfigManager.registerGlobalServerFlowProperty(serverFlowDs.getProperty());
        DecryptAcmWhiteDataSource<ClusterClientAssignConfig> clientAssignDs = new DecryptAcmWhiteDataSource<ClusterClientAssignConfig>(consoleTenantId, clusterMapDataId, "ahas-sentinel", new ClusterClientAssignConfigParser(), this.decryptor);
        ClusterClientConfigManager.registerServerAssignProperty(clientAssignDs.getProperty());
        String clientConfigDataId = SentinelAcmConstants.formClusterClientConfigDataId(userId, acmNamespace, appName);
        DecryptAcmWhiteDataSource<ClusterClientConfig> clientConfigDs = new DecryptAcmWhiteDataSource<ClusterClientConfig>(consoleTenantId, clientConfigDataId, "ahas-sentinel", new ClusterClientCommonConfigParser(), this.decryptor);
        ClusterClientConfigManager.registerClientConfigProperty(clientConfigDs.getProperty());
        DecryptAcmWhiteDataSource<Integer> clusterStateDs = new DecryptAcmWhiteDataSource<Integer>(consoleTenantId, clusterMapDataId, "ahas-sentinel", new ClusterAssignStateParser(), this.decryptor);
        ClusterStateManager.registerProperty(clusterStateDs.getProperty());
        ClusterServerConfigManager.loadServerNamespaceSet(Collections.singleton(appName));
    }

    private void initApiGatewayDs(String userId, String acmNamespace, String consoleTenantId, String appName) throws DiamondException {
        RecordLog.info("[SentinelAcmDsService] Initializing data source for API gateway integration", new Object[0]);
        String gatewayFlowRuleDataId = SentinelAcmConstants.formGatewayFlowRuleDataId(userId, acmNamespace, appName);
        DecryptAcmWhiteDataSource<Set<GatewayFlowRule>> gatewayFlowRuleDs = new DecryptAcmWhiteDataSource<Set<GatewayFlowRule>>(consoleTenantId, gatewayFlowRuleDataId, "ahas-sentinel", new GatewayFlowRuleParser(), this.decryptor);
        GatewayRuleManager.register2Property(gatewayFlowRuleDs.getProperty());
        String gatewayApiDefDataId = SentinelAcmConstants.formGatewayApiDefinitionDataId(userId, acmNamespace, appName);
        DecryptAcmWhiteDataSource<Set<ApiDefinition>> gatewayApiDefinitionDs = new DecryptAcmWhiteDataSource<Set<ApiDefinition>>(consoleTenantId, gatewayApiDefDataId, "ahas-sentinel", new GatewayApiDefinitionParser(), this.decryptor);
        GatewayApiDefinitionManager.register2Property(gatewayApiDefinitionDs.getProperty());
    }

    private boolean isGatewayAppType() {
        return AhasSentinelConstants.GATEWAY_APP_TYPES.contains(com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.util.AppNameUtil.getAppType());
    }

    private void initSettingDs(String userId, String acmNamespace, String consoleTenantId, String appName) throws DiamondException {
        String gsDataId = SentinelAcmConstants.formGeneralSettingDataId(userId, acmNamespace, appName);
        DecryptAcmWhiteDataSource<SentinelGeneralSettingEntity> generalSettingDs = new DecryptAcmWhiteDataSource<SentinelGeneralSettingEntity>(consoleTenantId, gsDataId, "ahas-sentinel", new SentinelGeneralSettingParser(), this.decryptor);
        GeneralSettingManager.register2Property(generalSettingDs.getProperty());
        String asDataId = SentinelAcmConstants.formAdapterSettingDataId(userId, acmNamespace, appName);
        DecryptAcmWhiteDataSource<SentinelAdapterSettingEntity> adapterSettingDs = new DecryptAcmWhiteDataSource<SentinelAdapterSettingEntity>(consoleTenantId, asDataId, "ahas-sentinel", new SentinelAdapterSettingParser(), this.decryptor);
        AdapterSettingManager.register2Property(adapterSettingDs.getProperty());
    }
}

