/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.sentinel.datasource.parser.cluster;

import com.alibaba.csp.ahas.sentinel.cluster.entity.ClusterGroupEntity;
import com.alibaba.csp.ahas.sentinel.util.MachineUtils;
import com.alibaba.csp.ahas.shaded.com.alibaba.csp.sentinel.datasource.acm.DataAcmFormat;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.JSON;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.TypeReference;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.parser.Feature;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientAssignConfig;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.log.RecordLog;
import java.util.List;

public class ClusterClientAssignConfigParser
implements Converter<String, ClusterClientAssignConfig> {
    @Override
    public ClusterClientAssignConfig convert(String source) {
        if (source == null) {
            return null;
        }
        String data = new DataAcmFormat(source).getData();
        RecordLog.info("[ClusterClientAssignConfigParser] Get data: " + data, new Object[0]);
        List<ClusterGroupEntity> groupList = JSON.parseObject(data, new TypeReference<List<ClusterGroupEntity>>(){}, new Feature[0]);
        if (groupList == null || groupList.isEmpty()) {
            return null;
        }
        return this.extractClientAssignment(groupList);
    }

    private ClusterClientAssignConfig extractClientAssignment(List<ClusterGroupEntity> groupList) {
        for (ClusterGroupEntity group : groupList) {
            if (!MachineUtils.isCurrentMachineEqual(group)) continue;
            return null;
        }
        for (ClusterGroupEntity group : groupList) {
            if (!group.getClientSet().contains(MachineUtils.getCurrentProcessConfigurationId())) continue;
            String ip = group.getServerIp();
            Integer port = group.getServerPort();
            return new ClusterClientAssignConfig(ip, port);
        }
        return null;
    }
}

