/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.sentinel.datasource.parser.cluster;

import com.alibaba.csp.ahas.sentinel.cluster.entity.ClusterGroupEntity;
import com.alibaba.csp.ahas.sentinel.util.MachineUtils;
import com.alibaba.csp.ahas.shaded.com.alibaba.csp.sentinel.datasource.acm.DataAcmFormat;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.JSON;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.TypeReference;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.parser.Feature;
import com.alibaba.csp.sentinel.cluster.server.config.ClusterServerConfigManager;
import com.alibaba.csp.sentinel.cluster.server.config.ServerFlowConfig;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.log.RecordLog;
import java.util.List;

public class ClusterServerFlowConfigParser
implements Converter<String, ServerFlowConfig> {
    @Override
    public ServerFlowConfig convert(String source) {
        if (source == null) {
            return null;
        }
        String data = new DataAcmFormat(source).getData();
        RecordLog.info("[ClusterServerFlowConfigParser] Get data: " + data, new Object[0]);
        List<ClusterGroupEntity> groupList = JSON.parseObject(data, new TypeReference<List<ClusterGroupEntity>>(){}, new Feature[0]);
        if (groupList == null || groupList.isEmpty()) {
            return null;
        }
        return this.extractServerFlowConfig(groupList);
    }

    private ServerFlowConfig extractServerFlowConfig(List<ClusterGroupEntity> groupList) {
        for (ClusterGroupEntity group : groupList) {
            if (!MachineUtils.isCurrentMachineEqual(group)) continue;
            return new ServerFlowConfig().setExceedCount(ClusterServerConfigManager.getExceedCount()).setIntervalMs(ClusterServerConfigManager.getIntervalMs()).setMaxAllowedQps(group.getMaxAllowedQps()).setMaxOccupyRatio(ClusterServerConfigManager.getMaxOccupyRatio()).setSampleCount(ClusterServerConfigManager.getSampleCount());
        }
        return null;
    }
}

