/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.endpoint;

import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.endpoint.EndpointResolverBase;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.endpoint.ResolveEndpointRequest;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.google.gson.JsonArray;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.google.gson.JsonElement;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.google.gson.JsonObject;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.google.gson.JsonParser;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;

public class LocalConfigRegionalEndpointResolver
extends EndpointResolverBase {
    protected static final String ENDPOINT_JSON = "endpoints.json";
    private Set<String> validRegionIds = new HashSet<String>();
    private Map<String, String> locationCodeMapping = new HashMap<String, String>();
    private JsonObject regionalEndpointData;

    public LocalConfigRegionalEndpointResolver() {
        JsonObject obj = this.readLocalConfigAsJsonObject();
        this.initLocalConfig(obj);
    }

    public LocalConfigRegionalEndpointResolver(String configJsonStr) {
        JsonObject obj = new JsonParser().parse(configJsonStr).getAsJsonObject();
        this.initLocalConfig(obj);
    }

    private void initLocalConfig(JsonObject obj) {
        this.initRegionalEndpointData(obj);
        this.initRegionIds(obj);
        this.initLocationCodeMapping(obj);
    }

    private void initRegionalEndpointData(JsonObject obj) {
        if (!obj.has("regional_endpoints")) {
            return;
        }
        this.regionalEndpointData = obj.get("regional_endpoints").getAsJsonObject();
        JsonObject regionalEndpoints = obj.get("regional_endpoints").getAsJsonObject();
        for (String normalizedProductCode : regionalEndpoints.keySet()) {
            JsonObject productData = regionalEndpoints.get(normalizedProductCode).getAsJsonObject();
            for (String regionId : productData.keySet()) {
                String endpoint = productData.get(regionId).getAsString();
                this.putEndpointEntry(this.makeEndpointKey(normalizedProductCode, regionId), endpoint);
            }
        }
    }

    protected void initRegionIds(JsonObject obj) {
        if (!obj.has("regions")) {
            return;
        }
        JsonArray regions = obj.get("regions").getAsJsonArray();
        for (JsonElement regionData : regions) {
            this.validRegionIds.add(regionData.getAsString());
        }
    }

    protected void initLocationCodeMapping(JsonObject obj) {
        if (!obj.has("location_code_mapping")) {
            return;
        }
        JsonObject mappingData = obj.get("location_code_mapping").getAsJsonObject();
        for (String productCode : mappingData.keySet()) {
            String locationServiceCode = mappingData.get(productCode).getAsString();
            this.locationCodeMapping.put(productCode, locationServiceCode);
        }
    }

    protected String getNormalizedProductCode(String productCode) {
        String productCodeLower = productCode.toLowerCase();
        if (this.locationCodeMapping.containsKey(productCodeLower)) {
            return this.locationCodeMapping.get(productCodeLower);
        }
        return productCodeLower;
    }

    protected JsonObject readLocalConfigAsJsonObject() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream is = classLoader.getResourceAsStream(ENDPOINT_JSON);
        Scanner scanner = new Scanner(is, "UTF-8").useDelimiter("\u0000");
        String jsonStr = scanner.hasNext() ? scanner.next() : "";
        scanner.close();
        JsonObject endpointData = new JsonParser().parse(jsonStr).getAsJsonObject();
        return endpointData;
    }

    @Override
    public String resolve(ResolveEndpointRequest request) {
        if (request.isOpenApiEndpoint()) {
            return this.fetchEndpointEntry(request);
        }
        return null;
    }

    @Override
    public String makeEndpointKey(ResolveEndpointRequest request) {
        return this.makeEndpointKey(request.productCodeLower, request.regionId);
    }

    public String makeEndpointKey(String productCodeLower, String regionId) {
        return this.getNormalizedProductCode(productCodeLower) + "." + regionId.toLowerCase();
    }

    @Override
    public boolean isRegionIdValid(String regionId) {
        return this.validRegionIds.contains(regionId);
    }

    @Override
    public Set<String> getValidRegionIdsByProduct(String productCodeLower) {
        String code = this.getNormalizedProductCode(productCodeLower);
        if (this.regionalEndpointData != null && this.regionalEndpointData.has(code)) {
            Set<String> validRegionIdsByProduct = this.regionalEndpointData.get(code).getAsJsonObject().keySet();
            return validRegionIdsByProduct;
        }
        return null;
    }

    @Override
    public boolean isProductCodeValid(String productCode) {
        return super.isProductCodeValid(this.getNormalizedProductCode(productCode));
    }
}

