/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricLevel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class MetricObject {
    private String metric;
    private Long timestamp;
    private Object value;
    private MetricType metricType;
    private Map<String, String> tags = new HashMap<String, String>();
    private MetricLevel metricLevel;
    private transient String meterName;
    private int interval = -1;

    private MetricObject() {
    }

    public static Builder named(String name) {
        return new Builder(name);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricObject)) {
            return false;
        }
        MetricObject rhs = (MetricObject)o;
        return this.equals(this.metric, rhs.metric) && this.equals(this.tags, rhs.tags) && this.equals((Object)this.metricType, (Object)rhs.metricType) && this.equals((Object)this.metricLevel, (Object)rhs.metricLevel);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.metric, this.tags, this.metricType, this.metricLevel});
    }

    public String toString() {
        return this.getClass().getSimpleName() + "->metric: " + this.metric + ",value: " + this.value + ",timestamp: " + this.timestamp + ",type: " + (Object)((Object)this.metricType) + ",tags: " + this.tags + ",level: " + (Object)((Object)this.metricLevel);
    }

    public String getMetric() {
        return this.metric;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public Object getValue() {
        return this.value;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public MetricLevel getMetricLevel() {
        return this.metricLevel;
    }

    public MetricType getMetricType() {
        return this.metricType;
    }

    public int getInterval() {
        return this.interval;
    }

    public String getMeterName() {
        return this.meterName;
    }

    private boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static enum MetricType {
        COUNTER,
        GAUGE,
        DELTA,
        PERCENTILE;

    }

    public static class Builder {
        private final MetricObject metric = new MetricObject();

        public Builder(String name) {
            this.metric.metric = name;
        }

        public MetricObject build() {
            return this.metric;
        }

        public Builder withValue(Object value) {
            this.metric.value = value;
            return this;
        }

        public Builder withTimestamp(Long timestamp) {
            this.metric.timestamp = timestamp;
            return this;
        }

        public Builder withTags(Map<String, String> tags) {
            if (tags != null) {
                for (Map.Entry<String, String> entry : tags.entrySet()) {
                    this.metric.tags.put(entry.getKey(), entry.getValue());
                }
            }
            return this;
        }

        public Builder withType(MetricType type) {
            this.metric.metricType = type;
            return this;
        }

        public Builder withLevel(MetricLevel level) {
            this.metric.metricLevel = level;
            return this;
        }

        public Builder withInterval(int interval) {
            this.metric.interval = interval;
            return this;
        }

        public Builder withMeterName(String meterName) {
            this.metric.meterName = meterName;
            return this;
        }
    }
}

