/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.jvm;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Metric;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.PersistentGauge;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;

public class ClassLoadingGaugeSet
implements MetricSet {
    private final ClassLoadingMXBean mxBean;

    public ClassLoadingGaugeSet() {
        this(ManagementFactory.getClassLoadingMXBean());
    }

    public ClassLoadingGaugeSet(ClassLoadingMXBean mxBean) {
        this.mxBean = mxBean;
    }

    @Override
    public Map<MetricName, Metric> getMetrics() {
        HashMap<MetricName, Metric> gauges = new HashMap<MetricName, Metric>();
        gauges.put(MetricName.build("loaded"), new PersistentGauge<Long>(){

            @Override
            public Long getValue() {
                return ClassLoadingGaugeSet.this.mxBean.getTotalLoadedClassCount();
            }
        });
        gauges.put(MetricName.build("loaded_current"), new PersistentGauge<Integer>(){

            @Override
            public Integer getValue() {
                return ClassLoadingGaugeSet.this.mxBean.getLoadedClassCount();
            }
        });
        gauges.put(MetricName.build("unloaded"), new PersistentGauge<Long>(){

            @Override
            public Long getValue() {
                return ClassLoadingGaugeSet.this.mxBean.getUnloadedClassCount();
            }
        });
        return gauges;
    }

    @Override
    public long lastUpdateTime() {
        return System.currentTimeMillis();
    }
}

