/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.nginx;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;

public class NetUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Response request(String nginxHost, int port, String statusPath, String statusHost) {
        BufferedReader br = null;
        Socket s = new Socket();
        try {
            s.connect(new InetSocketAddress(nginxHost, port), 100);
            OutputStream outputStream = s.getOutputStream();
            StringBuilder requestPayload = new StringBuilder();
            requestPayload.append("GET ").append(statusPath).append(" HTTP/1.1\r\n").append("Host: ").append(statusHost).append("\r\n").append("User-Agent: Ali-metrics Java Client\r\n").append("Connection: close\r\n").append("\r\n");
            outputStream.write(requestPayload.toString().getBytes());
            outputStream.flush();
            br = new BufferedReader(new InputStreamReader(s.getInputStream()));
            StringBuilder sb = new StringBuilder();
            String line = null;
            boolean start = false;
            boolean success = false;
            while ((line = br.readLine()) != null) {
                if (start) {
                    sb.append(line).append("\n");
                }
                if ("".equals(line)) {
                    start = true;
                }
                if (!"HTTP/1.1 200 OK".equals(line)) continue;
                success = true;
            }
            String result = sb.toString().trim();
            Response response = new Response(result, success);
            return response;
        }
        catch (Exception e) {
            Response response = new Response(e.getMessage(), false);
            return response;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
            try {
                s.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static class Response {
        private boolean success;
        private String content;

        public Response(String content, boolean success) {
            this.success = success;
            this.content = content;
        }

        public Response(String content) {
            this.content = content;
            this.success = true;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getContent() {
            return this.content;
        }
    }
}

