/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.nginx;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.CachedMetricSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Clock;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Metric;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.PersistentGauge;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.nginx.NetUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class NginxGaugeSet
extends CachedMetricSet {
    private static final String[] DELTA = new String[]{"conn.accepted", "conn.handled", "request.qps", "request.processing_time"};
    private static final String[] GAUGES = new String[]{"conn.active", "conn.reading", "conn.writing", "conn.waiting"};
    private static final String SPACE = "\\s+";
    private static final String DEFAULT_NGINX_HOST = "127.0.0.1";
    private static final int DEFAULT_NGINX_PORT = 80;
    private static final String DEFAULT_NGINX_STATUS_PATH = "/nginx_status";
    private static final String DEFAULT_STATUS_HOST = "127.0.0.1";
    private String nginxHost;
    private int nginxPort;
    private String statusPath;
    private String statusHost;
    private long[] counters;
    private double[] rates;
    private double averageRt;
    private long[] gauges;
    private boolean firstCollection;
    private Map<MetricName, Metric> metrics;

    public NginxGaugeSet() {
        this("127.0.0.1", 80, DEFAULT_NGINX_STATUS_PATH, "127.0.0.1", DEFAULT_DATA_TTL, TimeUnit.MILLISECONDS, Clock.defaultClock());
    }

    public NginxGaugeSet(long dataTTL, TimeUnit unit) {
        this("127.0.0.1", 80, DEFAULT_NGINX_STATUS_PATH, "127.0.0.1", dataTTL, unit, Clock.defaultClock());
    }

    public NginxGaugeSet(String nginxHost, int nginxPort, String statusPath, String statusHost, long dataTTL, TimeUnit unit, Clock clock) {
        super(dataTTL, unit, clock);
        this.nginxHost = nginxHost;
        this.nginxPort = nginxPort;
        this.statusPath = statusPath;
        this.statusHost = statusHost;
        this.counters = new long[DELTA.length];
        this.rates = new double[DELTA.length - 1];
        this.gauges = new long[GAUGES.length];
        this.firstCollection = true;
        this.metrics = new HashMap<MetricName, Metric>();
        this.populateGauges();
    }

    @Override
    protected void getValueInternal() {
        String[] data;
        this.clear();
        for (String line : data = this.fetchNginxMetrics()) {
            String[] tokens;
            if (line.startsWith("Active")) {
                this.gauges[0] = Long.parseLong(line.split(SPACE)[2]);
                continue;
            }
            if (line.startsWith(" ")) {
                tokens = line.trim().split(SPACE);
                if (tokens.length < 3) continue;
                long[] latest = new long[DELTA.length];
                latest[0] = Long.parseLong(tokens[0]);
                latest[1] = Long.parseLong(tokens[1]);
                latest[2] = Long.parseLong(tokens[2]);
                if (tokens.length >= 4) {
                    latest[3] = Long.parseLong(tokens[3]);
                }
                if (!this.firstCollection) {
                    long[] deltas = new long[this.counters.length];
                    for (int i = 0; i < this.counters.length; ++i) {
                        long temp = latest[i] - this.counters[i];
                        deltas[i] = temp >= 0L ? temp : -10001L;
                    }
                    long duration = this.clock.getTime() - this.lastCollectTime.get();
                    for (int i = 0; i < this.rates.length; ++i) {
                        this.rates[i] = 1000.0 * (double)deltas[i] / (double)duration;
                    }
                    this.averageRt = deltas[2] == 0L ? 0.0 : (deltas[2] == -10001L || deltas[3] == -10001L ? -10001.0 : (double)deltas[3] / (double)deltas[2]);
                }
                System.arraycopy(latest, 0, this.counters, 0, this.counters.length);
                if (!this.firstCollection) continue;
                this.firstCollection = false;
                continue;
            }
            if (!line.startsWith("Reading:")) continue;
            tokens = line.split(SPACE);
            this.gauges[1] = Long.parseLong(tokens[1]);
            this.gauges[2] = Long.parseLong(tokens[3]);
            this.gauges[3] = Long.parseLong(tokens[5]);
        }
    }

    @Override
    public Map<MetricName, Metric> getMetrics() {
        return this.metrics;
    }

    protected String[] fetchNginxMetrics() {
        NetUtils.Response response = NetUtils.request(this.nginxHost, this.nginxPort, this.statusPath, this.statusHost);
        if (response.isSuccess()) {
            return response.getContent().split("\n");
        }
        return new String[0];
    }

    private void clear() {
        int i;
        for (i = 0; i < this.rates.length; ++i) {
            this.rates[i] = 0.0;
        }
        this.averageRt = 0.0;
        for (i = 0; i < this.gauges.length; ++i) {
            this.gauges[i] = 0L;
        }
    }

    private void populateGauges() {
        int i;
        for (i = 0; i < this.rates.length; ++i) {
            this.metrics.put(MetricName.build(DELTA[i]), new NginxRateGauge(i));
        }
        for (i = 0; i < this.gauges.length; ++i) {
            this.metrics.put(MetricName.build(GAUGES[i]), new NginxGauge(i));
        }
        this.metrics.put(MetricName.build("request.avg_rt"), new PersistentGauge<Double>(){

            @Override
            public Double getValue() {
                return NginxGaugeSet.this.averageRt;
            }
        });
    }

    private class NginxGauge
    extends PersistentGauge<Long> {
        private int index;

        public NginxGauge(int index) {
            this.index = index;
        }

        @Override
        public Long getValue() {
            try {
                NginxGaugeSet.this.refreshIfNecessary();
                return NginxGaugeSet.this.gauges[this.index];
            }
            catch (Exception e) {
                return 0L;
            }
        }
    }

    private class NginxRateGauge
    extends PersistentGauge<Double> {
        private int index;

        public NginxRateGauge(int index) {
            this.index = index;
        }

        @Override
        public Double getValue() {
            try {
                NginxGaugeSet.this.refreshIfNecessary();
                return NginxGaugeSet.this.rates[this.index];
            }
            catch (Exception e) {
                return 0.0;
            }
        }
    }
}

