/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.os.linux;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.CachedMetricSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Clock;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Metric;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.PersistentGauge;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.os.utils.FileUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetTrafficGaugeSet
extends CachedMetricSet {
    private static final Logger logger = LoggerFactory.getLogger(NetTrafficGaugeSet.class);
    private static final String DEFAULT_FILE_PATH = "/proc/net/dev";
    private static final String STR_PATTERN = "\\s*(eth\\d+|em\\d+_\\d+/\\d+|em\\d+_\\d+|em\\d+p\\d+p\\d+_\\d+/\\d+|p\\d+p\\d+_\\d+|p\\d+p\\d+|(?:(?:en|sl|wl|ww)(?:b\\d+|c[0-9a-f]+|o\\d+(?:d\\d+)?|s\\d+(?:f\\d+)?(?:d\\d+)?|x[0-9a-f]+|p\\d+s\\d+(?:f\\d+)?(?:d\\d+)?|p\\d+s\\d+(?:f\\d+)?(?:u\\d+)*(?:c\\d+)?(?:i\\d+)?))):(.*)";
    private static final Pattern NET_PATTERN = Pattern.compile("\\s*(eth\\d+|em\\d+_\\d+/\\d+|em\\d+_\\d+|em\\d+p\\d+p\\d+_\\d+/\\d+|p\\d+p\\d+_\\d+|p\\d+p\\d+|(?:(?:en|sl|wl|ww)(?:b\\d+|c[0-9a-f]+|o\\d+(?:d\\d+)?|s\\d+(?:f\\d+)?(?:d\\d+)?|x[0-9a-f]+|p\\d+s\\d+(?:f\\d+)?(?:d\\d+)?|p\\d+s\\d+(?:f\\d+)?(?:u\\d+)*(?:c\\d+)?(?:i\\d+)?))):(.*)");
    private static final String[] FIELDS = new String[]{"net.in.bytes", "net.in.packets", "net.in.errs", "net.in.dropped", "net.in.fifo.errs", "net.in.frame.errs", "net.in.compressed", "net.in.multicast", "net.out.bytes", "net.out.packets", "net.out.errs", "net.out.dropped", "net.out.fifo.errs", "net.out.collisions", "net.out.carrier.errs", "net.out.compressed"};
    private static final String DELIM = "\\s+";
    private String filePath;
    private Map<String, Long[]> countByFace;
    private Map<String, Double[]> rateByFace;
    private Map<MetricName, Metric> gauges = new HashMap<MetricName, Metric>();

    public NetTrafficGaugeSet() {
        this(DEFAULT_FILE_PATH);
    }

    public NetTrafficGaugeSet(String filePath) {
        this(filePath, DEFAULT_DATA_TTL, TimeUnit.MILLISECONDS, Clock.defaultClock());
    }

    public NetTrafficGaugeSet(long dataTTL, TimeUnit unit) {
        this(DEFAULT_FILE_PATH, dataTTL, unit, Clock.defaultClock());
    }

    public NetTrafficGaugeSet(String filePath, long dataTTL, TimeUnit unit, Clock clock) {
        super(dataTTL, unit, clock);
        this.filePath = filePath;
        this.countByFace = new HashMap<String, Long[]>();
        this.rateByFace = new HashMap<String, Double[]>();
        this.getValueInternal();
        this.populateGauges();
    }

    @Override
    public Map<MetricName, Metric> getMetrics() {
        return this.gauges;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    @Override
    protected void getValueInternal() {
        try {
            List<String> lines = FileUtils.readFileAsStringArray(this.filePath);
            for (String line : lines) {
                Matcher netMatcher = NET_PATTERN.matcher(line);
                if (!netMatcher.matches()) continue;
                String face = netMatcher.group(1);
                if (this.countByFace.get(face) == null) {
                    Long[] counts = new Long[FIELDS.length];
                    Double[] rates = new Double[FIELDS.length];
                    for (int i = 0; i < counts.length; ++i) {
                        counts[i] = 0L;
                        rates[i] = 0.0;
                    }
                    this.countByFace.put(face, counts);
                    this.rateByFace.put(face, rates);
                }
                String[] stats = netMatcher.group(2).trim().split(DELIM);
                for (int i = 0; i < stats.length; ++i) {
                    try {
                        long count = Long.parseLong(stats[i]);
                        long delta = count - this.countByFace.get(face)[i];
                        if (this.countByFace.get(face)[i] == 0L) {
                            delta = 0L;
                        }
                        this.countByFace.get((Object)face)[i] = count;
                        long duration = this.clock.getTime() - this.lastCollectTime.get();
                        this.rateByFace.get((Object)face)[i] = 1000.0 * (double)delta / (double)duration;
                        continue;
                    }
                    catch (Exception e) {
                        logger.warn("Error parsing net traffic metrics:", e);
                    }
                }
            }
        }
        catch (IOException e) {
            logger.warn("Error during reading file {}", (Object)this.filePath, (Object)e);
        }
    }

    private void populateGauges() {
        for (Map.Entry<String, Long[]> entry : this.countByFace.entrySet()) {
            for (int i = 0; i < entry.getValue().length; ++i) {
                this.gauges.put(MetricName.build(FIELDS[i]).tagged("face", entry.getKey()), new NetGauge(entry.getKey(), i));
            }
        }
    }

    private class NetGauge
    extends PersistentGauge<Double> {
        private String face;
        private int index;

        public NetGauge(String face, int index) {
            this.face = face;
            this.index = index;
        }

        @Override
        public Double getValue() {
            try {
                NetTrafficGaugeSet.this.refreshIfNecessary();
                return ((Double[])NetTrafficGaugeSet.this.rateByFace.get(this.face))[this.index];
            }
            catch (Exception e) {
                return 0.0;
            }
        }
    }
}

