/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.os.windows;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.CachedMetricSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Clock;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Metric;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.PersistentGauge;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetTrafficGaugeSet
extends CachedMetricSet {
    private static final Logger logger = LoggerFactory.getLogger(NetTrafficGaugeSet.class);
    private static final String[] FIELDS = new String[]{"net.in.bytes", "net.in.packets", "net.in.errs", "net.in.dropped", "net.in.fifo.errs", "net.in.frame.errs", "net.in.compressed", "net.in.multicast", "net.out.bytes", "net.out.packets", "net.out.errs", "net.out.dropped", "net.out.fifo.errs", "net.out.collisions", "net.out.carrier.errs", "net.out.compressed"};
    private Map<String, Long[]> countByFace;
    private Map<String, Double[]> rateByFace;
    private Map<MetricName, Metric> gauges = new HashMap<MetricName, Metric>();

    public NetTrafficGaugeSet(long dataTTL, TimeUnit unit) {
        this(dataTTL, unit, Clock.defaultClock());
    }

    public NetTrafficGaugeSet(long dataTTL, TimeUnit unit, Clock clock) {
        super(dataTTL, unit, clock);
        this.countByFace = new HashMap<String, Long[]>();
        this.rateByFace = new HashMap<String, Double[]>();
        this.getValueInternal();
        this.populateGauges();
    }

    @Override
    public Map<MetricName, Metric> getMetrics() {
        return null;
    }

    @Override
    protected void getValueInternal() {
    }

    private void populateGauges() {
        for (Map.Entry<String, Long[]> entry : this.countByFace.entrySet()) {
            for (int i = 0; i < entry.getValue().length; ++i) {
                this.gauges.put(MetricName.build(FIELDS[i]).tagged("face", entry.getKey()), new NetGauge(entry.getKey(), i));
            }
        }
    }

    private class NetGauge
    extends PersistentGauge<Double> {
        private String face;
        private int index;

        public NetGauge(String face, int index) {
            this.face = face;
            this.index = index;
        }

        @Override
        public Double getValue() {
            try {
                NetTrafficGaugeSet.this.refreshIfNecessary();
                return ((Double[])NetTrafficGaugeSet.this.rateByFace.get(this.face))[this.index];
            }
            catch (Exception e) {
                return 0.0;
            }
        }
    }
}

