/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricLevel;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.MetricObject;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.config.MetricsCollectPeriodConfig;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.MetricsLog;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.server.MetricsMemoryCache;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.status.LogDescriptionManager;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.status.LogDescriptionRegister;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.utils.Constants;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.utils.FigureUtil;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.utils.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinAppender {
    private static final Logger logger = LoggerFactory.getLogger(BinAppender.class);
    private LogDescriptionRegister logDescriptionRegister = new LogDescriptionRegister();
    private ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("BinAppender"));
    private LogDescriptionManager logDescriptionManager;
    private MetricsMemoryCache cache;
    private Map<MetricLevel, MetricsLog> currentMetricsLog = new HashMap<MetricLevel, MetricsLog>();
    private long logTimestamp;
    private long baseTimestamp;
    private long lastTimestamp;
    private MetricsCollectPeriodConfig metricsCollectPeriodConfig;
    private String logRootPath;
    private int archiveHold;
    private int currentHold;
    private long maxFileSize = 0x40000000L;
    private AtomicBoolean working = new AtomicBoolean(false);

    public BinAppender(long timestamp, String logRootPath, MetricsCollectPeriodConfig metricsCollectPeriodConfig, LogDescriptionManager logDescriptionManager, MetricsMemoryCache cache, int archiveHold, int currentHold) {
        this.logTimestamp = timestamp;
        this.baseTimestamp = FigureUtil.getTodayStartTimestamp(timestamp);
        this.lastTimestamp = FigureUtil.getNextDayStartTimestamp(timestamp);
        this.cache = cache;
        this.logDescriptionManager = logDescriptionManager;
        this.metricsCollectPeriodConfig = metricsCollectPeriodConfig;
        this.logRootPath = logRootPath;
        this.archiveHold = archiveHold;
        this.currentHold = currentHold;
    }

    public void init() {
        this.createMetricsLog(this.baseTimestamp);
        this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    long timestamp = System.currentTimeMillis();
                    BinAppender.this.checkForRolling(timestamp);
                    BinAppender.this.checkForArchive();
                }
                catch (Throwable e) {
                    logger.error("BinAppender schedule task error.", e);
                }
            }
        }, 60L, 60L, TimeUnit.SECONDS);
    }

    public void initWithoutCheckThread() {
        this.createMetricsLog(this.baseTimestamp);
    }

    public void append(long metricsTime, Map<MetricLevel, List<MetricObject>> metricObjects, Map<MetricLevel, Long> lastUpdateTime) {
        if (metricObjects == null || metricObjects.size() == 0) {
            return;
        }
        if (metricsTime >= this.baseTimestamp) {
            if (metricsTime >= this.lastTimestamp) {
                this.changeDay(metricsTime);
            }
            for (MetricLevel level : metricObjects.keySet()) {
                if (level == null) {
                    logger.error("metriclevel in binappender is null");
                    continue;
                }
                if (metricsTime == lastUpdateTime.get((Object)level)) continue;
                MetricsLog metricsLog = this.currentMetricsLog.get((Object)level);
                if (metricsLog == null) {
                    // empty if block
                }
                try {
                    int interval = this.metricsCollectPeriodConfig.period(level) * 1000;
                    metricsTime = metricsTime / (long)interval * (long)interval;
                    metricsLog.write(metricsTime, metricObjects.get((Object)level));
                    if (lastUpdateTime.get((Object)level) < metricsTime) {
                        lastUpdateTime.put(level, metricsTime);
                    }
                    if (this.logDescriptionManager.getLastCollectionTime(level) >= metricsTime) continue;
                    this.logDescriptionManager.setLastCollectionTime(level, metricsTime);
                }
                catch (IOException e) {
                    logger.error("write exception", e);
                }
            }
        } else {
            logger.info("this metrics is yesterday's data, ignore it");
            return;
        }
    }

    public void changeDay(long timestamp) {
        for (Map.Entry<MetricLevel, MetricsLog> entry : this.currentMetricsLog.entrySet()) {
            try {
                entry.getValue().close();
            }
            catch (IOException e) {
                logger.error("Close metrics log fail!", e);
            }
        }
        this.logTimestamp = timestamp;
        this.baseTimestamp = FigureUtil.getTodayStartTimestamp(timestamp);
        this.lastTimestamp = FigureUtil.getNextDayStartTimestamp(timestamp);
        this.createMetricsLog(this.baseTimestamp);
    }

    private void createMetricsLog(long baseTimestamp) {
        this.logDescriptionRegister = new LogDescriptionRegister();
        HashMap<MetricLevel, String> fileNames = new HashMap<MetricLevel, String>();
        for (MetricLevel level : MetricLevel.values()) {
            String basePath = FileUtil.getMetricsDir(baseTimestamp, this.logRootPath);
            String dataSourceFileName = FileUtil.getDataSourceFileName(baseTimestamp, this.logRootPath, level);
            String indexFileName = FileUtil.getIndexFileName(baseTimestamp, this.logRootPath, level);
            String logFileName = FileUtil.getLogFileName(baseTimestamp, this.logRootPath, level);
            MetricsLog metricsLog = new MetricsLog(level, this.logDescriptionRegister, this.logDescriptionManager, this.cache, basePath, dataSourceFileName, indexFileName, logFileName, baseTimestamp);
            metricsLog.init();
            this.currentMetricsLog.put(level, metricsLog);
            fileNames.put(level, logFileName);
        }
        this.logDescriptionManager.setLogDescriptions(baseTimestamp, this.logDescriptionRegister);
    }

    private void writeBackendClose() throws IOException {
        if (this.currentMetricsLog == null) {
            return;
        }
        for (MetricLevel level : this.currentMetricsLog.keySet()) {
            MetricsLog metricsLog = this.currentMetricsLog.get((Object)level);
            metricsLog.close();
        }
    }

    private void checkForRolling(long timestamp) {
        Date date = new Date(timestamp);
        Date archiveHoldDate = new Date(date.getYear(), date.getMonth(), date.getDate() - this.archiveHold);
        Date currentHoldDate = new Date(date.getYear(), date.getMonth(), date.getDate() - this.currentHold);
        String pathForScan = FileUtil.getBasePath(this.logRootPath);
        logger.debug("Check and delete unnecessary file, path is {}... Current time is {}, we will delete archive data before {} and current data before {}", pathForScan, timestamp, archiveHoldDate.toString(), currentHoldDate.toString());
        File path = new File(pathForScan);
        if (path.exists()) {
            File[] files;
            for (File file : files = path.listFiles()) {
                if (file.isDirectory()) {
                    String dir = file.getName();
                    if (Constants.DATE_PATH_REGEX.matcher(dir).matches()) {
                        File[] childrens;
                        String[] times = dir.split("-");
                        Date fileDate = new Date(Integer.parseInt(times[0]) - 1900, Integer.parseInt(times[1]) - 1, Integer.parseInt(times[2]));
                        if (fileDate.before(archiveHoldDate)) {
                            boolean result = FileUtil.deleteDir(file);
                            logger.info("delete directory {},{}", (Object)file.getName(), (Object)result);
                            continue;
                        }
                        if (!fileDate.before(currentHoldDate)) continue;
                        for (File child : childrens = file.listFiles()) {
                            boolean result;
                            if (child.isDirectory()) {
                                result = FileUtil.deleteDir(child);
                                logger.info("delete directory {},{}", (Object)child.getName(), (Object)result);
                                continue;
                            }
                            if (Constants.CURRENTDATA_REGEX.matcher(child.getName()).matches()) {
                                result = child.delete();
                                logger.info("delete file {},{}", (Object)child.getName(), (Object)result);
                                continue;
                            }
                            if (!Constants.INDEX_V2_REGEX.matcher(child.getName()).matches()) continue;
                            result = child.delete();
                            logger.info("delete file {},{}", (Object)child.getName(), (Object)result);
                        }
                        continue;
                    }
                    boolean result = FileUtil.deleteDir(file);
                    logger.info("delete directory {},{}", (Object)file.getName(), (Object)result);
                    continue;
                }
                boolean result = file.delete();
                logger.info("delete file {},{}", (Object)file.getName(), (Object)result);
            }
        }
    }

    private void checkForArchive() {
    }

    public void close() {
        try {
            this.executor.shutdown();
            this.writeBackendClose();
        }
        catch (IOException e) {
            logger.error("Close binappender failed!", e.fillInStackTrace());
        }
    }

    public String getPath() {
        return this.logRootPath;
    }

    protected void flush() {
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        private NamedThreadFactory(String name) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "metrics-" + name + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(true);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

