/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.IntCodec;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.encodings.DeltaZigzagEncoding;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.filters.IntFilter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.filters.IntFilterFactory;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.io.IntOutputStream;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.packers.IntBitPacking;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.utils.CodecUtils;
import java.nio.IntBuffer;

public class IntDZBP
extends IntCodec {
    private final IntBitPacking bitPack;
    private final IntFilterFactory encodeFilterFactory;
    private final IntFilterFactory decodeFilterFactory;

    public IntDZBP setDebug(boolean value) {
        this.bitPack.setDebug(value);
        return this;
    }

    public boolean getDebug() {
        return this.bitPack.getDebug();
    }

    public IntDZBP(IntBitPacking bitPack) {
        this.bitPack = bitPack;
        this.encodeFilterFactory = new DZEncodeFilterFactory();
        this.decodeFilterFactory = new DZDecodeFilterFactory();
    }

    public IntDZBP() {
        this(new IntBitPacking());
    }

    public IntBitPacking getBitPacking() {
        return this.bitPack;
    }

    @Override
    public void compress(IntBuffer src, IntOutputStream dst) {
        CodecUtils.encodeBlockPack(src, this.encodeFilterFactory, this.bitPack, dst);
    }

    @Override
    public void decompress(IntBuffer src, IntOutputStream dst) {
        CodecUtils.decodeBlockPack(src, this.decodeFilterFactory, this.bitPack, dst);
    }

    @Override
    protected int decompressLength(IntBuffer src) {
        src.mark();
        int outLen = src.get();
        src.reset();
        return outLen;
    }

    public static byte[] toBytes(int[] src) {
        return new IntDZBP().compress(src);
    }

    public static int[] fromBytes(byte[] src) {
        return new IntDZBP().decompress(src);
    }

    public static class DZDecodeFilterFactory
    implements IntFilterFactory {
        @Override
        public IntFilter newFilter(int firstValue) {
            return new DZDecodeFilter(firstValue);
        }
    }

    public static class DZDecodeFilter
    extends DeltaZigzagEncoding.IntDecoder
    implements IntFilter {
        private int savedContext = 0;

        public DZDecodeFilter(int contextValue) {
            super(contextValue);
        }

        public DZDecodeFilter() {
            this(0);
        }

        @Override
        public int filterInt(int value) {
            return this.decodeInt(value);
        }

        @Override
        public void saveContext() {
            this.savedContext = this.contextValue;
        }

        @Override
        public void restoreContext() {
            this.contextValue = this.savedContext;
        }

        @Override
        public void resetContext() {
            this.contextValue = 0;
            this.savedContext = 0;
        }
    }

    public static class DZEncodeFilterFactory
    implements IntFilterFactory {
        @Override
        public IntFilter newFilter(int firstValue) {
            return new DZEncodeFilter(firstValue);
        }
    }

    public static class DZEncodeFilter
    extends DeltaZigzagEncoding.IntEncoder
    implements IntFilter {
        private int savedContext = 0;

        public DZEncodeFilter(int contextValue) {
            super(contextValue);
        }

        public DZEncodeFilter() {
            this(0);
        }

        @Override
        public int filterInt(int value) {
            return this.encodeInt(value);
        }

        @Override
        public void saveContext() {
            this.savedContext = this.contextValue;
        }

        @Override
        public void restoreContext() {
            this.contextValue = this.savedContext;
        }

        @Override
        public void resetContext() {
            this.contextValue = 0;
            this.savedContext = 0;
        }
    }
}

