/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.LongCodec;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.encodings.DeltaEncoding;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.filters.LongEncodingFilter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.filters.LongFilterFactory;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.io.LongArrayOutputStream;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.io.LongDecompressStream;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.io.LongInputStream;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.io.LongOutputStream;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.packers.LongBitPacking;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.utils.CodecUtils;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.utils.Jaccard;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.utils.ReaderIterator;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class LongAscSDBP
extends LongCodec {
    private final LongBitPacking bitPack;
    private final LongFilterFactory encodeFilterFactory;
    private final LongFilterFactory decodeFilterFactory;

    public LongAscSDBP(LongBitPacking bitPack) {
        this.bitPack = bitPack;
        this.encodeFilterFactory = new LongEncodingFilter.Factory(new DeltaEncoding.LongAscendEncoder());
        this.decodeFilterFactory = new LongEncodingFilter.Factory(new DeltaEncoding.LongAscendDecoder());
    }

    public LongAscSDBP() {
        this(new LongBitPacking());
    }

    @Override
    public void compress(LongBuffer src, LongOutputStream dst) {
        CodecUtils.encodeBlockPack(src, this.encodeFilterFactory, this.bitPack, dst);
    }

    @Override
    public void decompress(LongBuffer src, LongOutputStream dst) {
        CodecUtils.decodeBlockPack(src, this.decodeFilterFactory, this.bitPack, dst);
    }

    public static byte[] toBytes(long[] src) {
        return new LongAscSDBP().compress(src);
    }

    public static long[] fromBytes(byte[] src) {
        return new LongAscSDBP().decompress(src);
    }

    public static Iterable<Long> toIterable(final byte[] src) {
        return new Iterable<Long>(){

            @Override
            public Iterator<Long> iterator() {
                return new ReaderIterator(new LongDecompressStream(ByteBuffer.wrap(src).asLongBuffer(), new LongEncodingFilter.Factory(new DeltaEncoding.LongAscendDecoder()), new LongBitPacking()));
            }
        };
    }

    static Reader newBytesDecompressReader(ByteBuffer b) {
        LongDecompressStream ds = new LongDecompressStream(b.asLongBuffer(), new LongEncodingFilter.Factory(new DeltaEncoding.LongAscendDecoder()), new LongBitPacking());
        Reader r = new Reader(ds);
        r.read();
        return r;
    }

    static void skipEqualOrLessValues(List<Reader> readers, long n) {
        for (Reader r : readers) {
            Long v = r.last();
            while (v != null && v <= n) {
                v = r.read();
            }
        }
    }

    static Long fetchMinimumLong(List<Reader> readers) {
        Reader minR = null;
        for (Reader r : readers) {
            Long v = r.last();
            if (v == null || minR != null && v >= minR.last()) continue;
            minR = r;
        }
        if (minR == null) {
            return null;
        }
        Long minV = minR.last();
        LongAscSDBP.skipEqualOrLessValues(readers, minV);
        return minV;
    }

    static boolean allReadersHaveLong(List<Reader> readers, long n) {
        boolean retval = true;
        for (Reader r : readers) {
            Long v = r.last();
            if (v != null && v == n) continue;
            retval = false;
            break;
        }
        LongAscSDBP.skipEqualOrLessValues(readers, n);
        return retval;
    }

    static boolean anyReadersHaveLong(List<Reader> readers, long n) {
        boolean retval = false;
        for (Reader r : readers) {
            Long v = r.last();
            if (v == null || v != n) continue;
            retval = true;
            break;
        }
        LongAscSDBP.skipEqualOrLessValues(readers, n);
        return retval;
    }

    private static ByteBuffer[] toByteBufferArray(byte[][] bufArray) {
        ByteBuffer[] results = new ByteBuffer[bufArray.length];
        for (int i = 0; i < bufArray.length; ++i) {
            results[i] = ByteBuffer.wrap(bufArray[i]);
        }
        return results;
    }

    public static byte[] union(byte[] a, byte[] b, byte[] ... others) {
        return LongAscSDBP.union(ByteBuffer.wrap(a), ByteBuffer.wrap(b), LongAscSDBP.toByteBufferArray(others));
    }

    public static byte[] union(ByteBuffer a, ByteBuffer b, ByteBuffer ... others) {
        LinkedList<Reader> readers = new LinkedList<Reader>();
        readers.add(LongAscSDBP.newBytesDecompressReader(a));
        readers.add(LongAscSDBP.newBytesDecompressReader(b));
        for (ByteBuffer c : others) {
            readers.add(LongAscSDBP.newBytesDecompressReader(c));
        }
        return LongAscSDBP.toBytes(LongAscSDBP.union(readers).toLongArray());
    }

    public static LongArrayOutputStream union(List<Reader> readers) {
        Long n;
        LongArrayOutputStream os = new LongArrayOutputStream();
        while ((n = LongAscSDBP.fetchMinimumLong(readers)) != null) {
            os.write(n);
        }
        return os;
    }

    public static byte[] intersect(byte[] a, byte[] b, byte[] ... others) {
        return LongAscSDBP.intersect(ByteBuffer.wrap(a), ByteBuffer.wrap(b), LongAscSDBP.toByteBufferArray(others));
    }

    public static byte[] intersect(ByteBuffer a, ByteBuffer b, ByteBuffer ... others) {
        Reader pivot = LongAscSDBP.newBytesDecompressReader(a);
        LinkedList<Reader> readers = new LinkedList<Reader>();
        readers.add(LongAscSDBP.newBytesDecompressReader(b));
        for (ByteBuffer c : others) {
            readers.add(LongAscSDBP.newBytesDecompressReader(c));
        }
        return LongAscSDBP.toBytes(LongAscSDBP.intersect(pivot, readers).toLongArray());
    }

    public static LongArrayOutputStream intersect(Reader pivot, List<Reader> readers) {
        LongArrayOutputStream os = new LongArrayOutputStream();
        Long n = pivot.last;
        while (n != null) {
            if (LongAscSDBP.allReadersHaveLong(readers, n)) {
                os.write(n);
            }
            n = pivot.read();
        }
        return os;
    }

    public static byte[] difference(byte[] a, byte[] b, byte[] ... others) {
        return LongAscSDBP.difference(ByteBuffer.wrap(a), ByteBuffer.wrap(b), LongAscSDBP.toByteBufferArray(others));
    }

    public static byte[] difference(ByteBuffer a, ByteBuffer b, ByteBuffer ... others) {
        Reader pivot = LongAscSDBP.newBytesDecompressReader(a);
        LinkedList<Reader> readers = new LinkedList<Reader>();
        readers.add(LongAscSDBP.newBytesDecompressReader(b));
        for (ByteBuffer c : others) {
            readers.add(LongAscSDBP.newBytesDecompressReader(c));
        }
        return LongAscSDBP.toBytes(LongAscSDBP.difference(pivot, readers).toLongArray());
    }

    public static LongArrayOutputStream difference(Reader pivot, List<Reader> readers) {
        LongArrayOutputStream os = new LongArrayOutputStream();
        Long v = pivot.last;
        while (v != null) {
            if (!LongAscSDBP.anyReadersHaveLong(readers, v)) {
                os.write(v);
            }
            v = pivot.read();
        }
        return os;
    }

    public static double jaccard(byte[] a, byte[] b) {
        return Jaccard.jaccard(LongAscSDBP.toIterable(a), LongAscSDBP.toIterable(b));
    }

    public static class Reader {
        LongInputStream stream;
        Long last = null;

        public Reader(LongInputStream stream) {
            this.stream = stream;
        }

        public Long read() {
            this.last = this.stream.read();
            return this.last;
        }

        public Long last() {
            return this.last;
        }
    }
}

