/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.status;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricLevel;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.StringUtils;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.bean.MetricSearch;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.MetricObject;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.DataSource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LogDescriptionRegister {
    private long visitTime = Long.MAX_VALUE;
    private int currentOffset = 0;
    private int currentOrder = 0;
    private Map<String, Map<MetricObject, DataSource>> dataSources = new HashMap<String, Map<MetricObject, DataSource>>();

    public void addDataSources(MetricObject metricObject, DataSource dataSource) {
        String metricName = metricObject.getMetric();
        Map<MetricObject, DataSource> dataSourcesByKey = this.dataSources.get(metricName);
        if (dataSourcesByKey == null) {
            dataSourcesByKey = new HashMap<MetricObject, DataSource>();
            this.dataSources.put(metricName, dataSourcesByKey);
        }
        dataSourcesByKey.put(dataSource.getMetricObject(), dataSource);
    }

    public void addDataSources(Map<MetricObject, DataSource> dataSources) {
        if (dataSources != null) {
            for (Map.Entry<MetricObject, DataSource> entry : dataSources.entrySet()) {
                this.addDataSources(entry.getKey(), entry.getValue());
            }
        }
    }

    public DataSource getDataSource(MetricObject metricObject) {
        String metricName = metricObject.getMetric();
        if (StringUtils.isNotBlank(metricName)) {
            Map<MetricObject, DataSource> dataSourcesByKey = this.dataSources.get(metricName);
            if (dataSourcesByKey == null) {
                return null;
            }
            return dataSourcesByKey.get(metricObject);
        }
        return null;
    }

    public Map<MetricLevel, Set<DataSource>> getMetricNames(List<MetricSearch> metricNames) {
        if (metricNames == null || metricNames.size() == 0) {
            return null;
        }
        HashMap<MetricLevel, Set<DataSource>> result = new HashMap<MetricLevel, Set<DataSource>>();
        for (MetricSearch simpleMetric : metricNames) {
            String key = simpleMetric.getKey();
            Map<String, String> tags = simpleMetric.getTags();
            Map<MetricObject, DataSource> dataSourcesByKey = this.dataSources.get(key);
            if (dataSourcesByKey == null) continue;
            for (Map.Entry<MetricObject, DataSource> entry0 : dataSourcesByKey.entrySet()) {
                DataSource dataSource = entry0.getValue();
                String metricObjectName = dataSource.getMetricName();
                boolean keysEqual = true;
                boolean tagsEqual = true;
                if (tags != null && tags.size() > 0) {
                    Map<String, String> dataSourceTag = dataSource.getTags();
                    if (dataSourceTag == null || dataSourceTag.size() == 0) {
                        tagsEqual = false;
                    } else {
                        for (Map.Entry<String, String> entry : tags.entrySet()) {
                            String entryKey = entry.getKey();
                            String entryValue = entry.getValue();
                            if (dataSourceTag.containsKey(entryKey)) {
                                if ("*".equals(entryValue) || entryValue == null) continue;
                                String[] metricTagValues = entryValue.split("\\|");
                                String dataSourceValue = dataSourceTag.get(entryKey);
                                boolean orMatch = false;
                                for (String tag : metricTagValues) {
                                    if (!StringUtils.equals(tag, dataSourceValue)) continue;
                                    orMatch = true;
                                    break;
                                }
                                if (orMatch) continue;
                                tagsEqual = false;
                                continue;
                            }
                            tagsEqual = false;
                            break;
                        }
                    }
                }
                if (!keysEqual || !tagsEqual) continue;
                this.addSearchResult(dataSource, result);
            }
        }
        return result;
    }

    private void addSearchResult(DataSource dataSource, Map<MetricLevel, Set<DataSource>> result) {
        MetricLevel level = dataSource.getLevel();
        Set<DataSource> dataSourceSet = result.get((Object)level);
        if (dataSourceSet == null) {
            dataSourceSet = result.put(level, new HashSet());
            dataSourceSet = result.get((Object)level);
        }
        dataSourceSet.add(dataSource);
    }

    public void clear() {
        this.dataSources = new HashMap<String, Map<MetricObject, DataSource>>();
    }

    public int getDataSourceNum() {
        return this.dataSources.size();
    }

    public int getCurrentOffset() {
        return this.currentOffset;
    }

    public void setCurrentOffset(int currentOffset) {
        this.currentOffset = currentOffset;
    }

    public int getCurrentOrder() {
        return this.currentOrder;
    }

    public long getVisitTime() {
        return this.visitTime;
    }

    public void setVisitTime(long visitTime) {
        this.visitTime = visitTime;
    }

    public void setCurrentOrder(int currentOrder) {
        this.currentOrder = currentOrder;
    }
}

