/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.middleware.tls.log;

import com.alibaba.csp.ahas.shaded.com.taobao.middleware.logger.Level;
import com.alibaba.csp.ahas.shaded.com.taobao.middleware.logger.Logger;
import com.alibaba.csp.ahas.shaded.com.taobao.middleware.logger.LoggerFactory;

public class TlsLogger {
    private static Logger logger = LoggerFactory.getLogger(TlsLogger.class);

    public static void info(String s) {
        logger.info(s);
    }

    public static void info(String appName, String s) {
        logger.info(TlsLogger.formatAppName(appName), s);
    }

    public static void warn(String s) {
        logger.warn(s);
    }

    public static void warn(String appName, String s) {
        logger.warn(TlsLogger.formatAppName(appName), s);
    }

    public static void error(String s) {
        logger.error("", s);
    }

    public static void error(String appName, String s) {
        logger.error(TlsLogger.formatAppName(appName), "", s);
    }

    public static void error(String s, Throwable throwable) {
        logger.error("", s, throwable);
    }

    private static String formatAppName(String appName) {
        return appName == null ? "" : appName;
    }

    static {
        String level = System.getProperty("tls.log.level", "INFO").toUpperCase();
        logger.setLevel(Level.codeOf(level));
        String size = System.getProperty("tls.log.size", "256MB").toUpperCase();
        if (!(size.endsWith("KB") || size.endsWith("MB") || size.endsWith("GB"))) {
            size = size.endsWith("K") || size.endsWith("M") || size.endsWith("G") ? size + "B" : size + "MB";
        }
        String backupStr = System.getProperty("tls.log.backup", "20");
        int backup = Integer.valueOf(backupStr);
        logger.activateAppenderWithSizeRolling("tls", "tls.log", "UTF-8", size, backup);
        logger.setAdditivity(false);
    }
}

